/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.genomic.PrimaryTranscript;
import org.biojava.bio.seq.impl.SimpleRNAFeature;
import org.biojava.bio.seq.impl.SimpleSequenceFactory;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SymbolList;

public class SimplePrimaryTranscript
extends SimpleRNAFeature
implements PrimaryTranscript {
    public SimplePrimaryTranscript(Sequence sequence, FeatureHolder featureHolder, PrimaryTranscript.Template template) throws IllegalAlphabetException {
        super(sequence, featureHolder, template);
    }

    public Sequence getRNA() {
        if (this.rna == null) {
            SymbolList symbolList;
            SimpleSequenceFactory simpleSequenceFactory = new SimpleSequenceFactory();
            try {
                symbolList = RNATools.transcribe(this.getSymbols());
            }
            catch (IllegalAlphabetException illegalAlphabetException) {
                throw new BioError(illegalAlphabetException, "Assertion Failure: Could not view sequence as RNA");
            }
            this.rna = simpleSequenceFactory.createSequence(symbolList, String.valueOf(this.getSequence().getURN()) + "/" + this.getType() + "/" + this.getLocation(), String.valueOf(this.getType()) + "/" + this.getLocation(), Annotation.EMPTY_ANNOTATION);
        }
        return this.rna;
    }
}

