/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import java.util.LinkedList;
import java.util.ListIterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.proteomics.Protease;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

public class Digest {
    private Protease protease = new Protease();
    private Sequence sequence;
    private int maxMissedCleavages = 0;
    public static String PEPTIDE_FEATURE_TYPE = "Peptide";
    public LinkedList peptideQue;

    public void addDigestFeatures() throws BioException, ChangeVetoException {
        this.peptideQue = new LinkedList();
        String string = this.protease.getCleaveageResidues();
        boolean bl = this.protease.isEndoProtease();
        String string2 = this.protease.getNotCleaveResidues();
        int n = 1;
        if (string == null || string2 == null) {
            throw new BioException("Protease contains null parameter");
        }
        int n2 = 1;
        while (n2 < this.sequence.length()) {
            int n3 = 0;
            while (n3 < string.length()) {
                if (this.sequence.symbolAt(n2).getToken() == string.charAt(n3)) {
                    if (bl) {
                        boolean bl2 = true;
                        if (n2 < this.sequence.length() - 1 && string2.indexOf(this.sequence.symbolAt(n2 + 1).getToken()) != -1) {
                            bl2 = false;
                        }
                        if (!bl2) break;
                        RangeLocation rangeLocation = new RangeLocation(n, n2);
                        this.peptideQue.add(rangeLocation);
                        n = n2 + 1;
                        break;
                    }
                    if (n2 <= 0) break;
                    RangeLocation rangeLocation = new RangeLocation(n, n2 - 1);
                    this.peptideQue.add(rangeLocation);
                    n = n2;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        if (n < this.sequence.length()) {
            RangeLocation rangeLocation = new RangeLocation(n, this.sequence.length());
            this.peptideQue.add(rangeLocation);
        }
        this.addMissedCleavages();
        ListIterator listIterator = this.peptideQue.listIterator();
        while (listIterator.hasNext()) {
            this.createPeptideFeature((Location)listIterator.next());
        }
    }

    private void addMissedCleavages() throws BioException {
        LinkedList<RangeLocation> linkedList = new LinkedList<RangeLocation>();
        if (this.maxMissedCleavages > 0) {
            ListIterator listIterator = this.peptideQue.listIterator();
            while (listIterator.hasNext()) {
                Location location = (Location)listIterator.next();
                Location location2 = null;
                int n = location.getMin();
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.maxMissedCleavages) {
                    if (listIterator.hasNext()) {
                        ++n3;
                        location2 = (Location)listIterator.next();
                        n2 = location2.getMax();
                        linkedList.add(new RangeLocation(n, n2));
                    }
                    ++n4;
                }
                int n5 = 0;
                while (n5 < n3) {
                    location = (Location)listIterator.previous();
                    ++n5;
                }
            }
            this.peptideQue.addAll(linkedList);
        }
    }

    private void createPeptideFeature(Location location) throws BioException, ChangeVetoException {
        Feature.Template template = new Feature.Template();
        template.type = PEPTIDE_FEATURE_TYPE;
        template.source = this.getClass().getName();
        template.location = location;
        template.annotation = Annotation.EMPTY_ANNOTATION;
        this.sequence.createFeature(template);
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setMaxMissedCleavages(int n) {
        this.maxMissedCleavages = n;
    }

    public void setProtese(Protease protease) {
        this.protease = protease;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }
}

