/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.search;

import java.util.Arrays;
import org.biojava.bio.seq.io.TokenParser;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.GappedSymbolList;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;

class GappedSymbolListBuilder {
    private static final int INCREMENT = 128;
    private TokenParser parser;
    private int[] gapIndices;
    SymbolList ungapped;
    GappedSymbolList gapped;

    GappedSymbolListBuilder(FiniteAlphabet finiteAlphabet) {
        this.parser = new TokenParser(finiteAlphabet);
    }

    SymbolList makeGappedSymbolList(StringBuffer stringBuffer) {
        this.gapIndices = new int[128];
        int n = 0;
        int n2 = stringBuffer.length() - 1;
        while (n2 >= 0) {
            if (stringBuffer.charAt(n2) == '-') {
                this.recordGap(++n, n2);
                stringBuffer.deleteCharAt(n2);
            }
            --n2;
        }
        Arrays.sort(this.gapIndices);
        try {
            this.ungapped = this.parser.parse(stringBuffer.toString());
            this.gapped = new GappedSymbolList(this.ungapped);
            int n3 = 0;
            while (n3 < this.gapIndices.length) {
                if (this.gapIndices[n3] > 0) {
                    this.gapped.addGapInView(this.gapIndices[n3] + 1);
                }
                ++n3;
            }
        }
        catch (IllegalSymbolException illegalSymbolException) {
            illegalSymbolException.printStackTrace();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
        }
        return this.gapped;
    }

    private void recordGap(int n, int n2) {
        if (n <= this.gapIndices.length) {
            this.gapIndices[n] = n2;
        } else {
            int[] nArray = new int[this.gapIndices.length + 128];
            System.arraycopy(this.gapIndices, 0, nArray, 0, this.gapIndices.length);
            this.gapIndices = nArray;
            this.gapIndices[n] = n2;
        }
    }
}

