/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Blas;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;
import cern.jet.math.PlusMult;

public class SeqBlas
implements Blas {
    public static final Blas seqBlas = new SeqBlas();
    private static final Functions F = Functions.functions;

    protected SeqBlas() {
    }

    public void assign(DoubleMatrix2D doubleMatrix2D, DoubleFunction doubleFunction) {
        doubleMatrix2D.assign(doubleFunction);
    }

    public void assign(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleDoubleFunction doubleDoubleFunction) {
        doubleMatrix2D.assign(doubleMatrix2D2, doubleDoubleFunction);
    }

    public double dasum(DoubleMatrix1D doubleMatrix1D) {
        return doubleMatrix1D.aggregate(Functions.plus, Functions.abs);
    }

    public void daxpy(double d, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.assign(doubleMatrix1D, Functions.plusMult(d));
    }

    public void dcopy(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.assign(doubleMatrix1D);
    }

    public double ddot(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        return doubleMatrix1D.zDotProduct(doubleMatrix1D2);
    }

    public void dgemm(boolean bl, boolean bl2, double d, DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d2, DoubleMatrix2D doubleMatrix2D3) {
        doubleMatrix2D.zMult(doubleMatrix2D2, doubleMatrix2D3, d, d2, bl, bl2);
    }

    public void dgemv(boolean bl, double d, DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, double d2, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix2D.zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, bl);
    }

    public void dger(double d, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix2D doubleMatrix2D) {
        PlusMult plusMult = PlusMult.plusMult(0.0);
        int n = doubleMatrix2D.rows();
        while (--n >= 0) {
            plusMult.multiplicator = doubleMatrix1D.getQuick(n);
            doubleMatrix2D.viewRow(n).assign(doubleMatrix1D2, plusMult);
        }
    }

    public double dnrm2(DoubleMatrix1D doubleMatrix1D) {
        return Math.sqrt(Algebra.DEFAULT.norm2(doubleMatrix1D));
    }

    public void drot(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d, double d2) {
        doubleMatrix1D.checkSize(doubleMatrix1D2);
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D.copy();
        doubleMatrix1D.assign(Functions.mult(d));
        doubleMatrix1D.assign(doubleMatrix1D2, Functions.plusMult(d2));
        doubleMatrix1D2.assign(Functions.mult(d));
        doubleMatrix1D2.assign(doubleMatrix1D3, Functions.minusMult(d2));
    }

    public void drotg(double d, double d2, double[] dArray) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = d2;
        if (Math.abs(d) > Math.abs(d2)) {
            d8 = d;
        }
        if ((d7 = Math.abs(d) + Math.abs(d2)) != 0.0) {
            double d9 = d / d7;
            double d10 = d2 / d7;
            d6 = d7 * Math.sqrt(d9 * d9 + d10 * d10);
            d6 = this.sign(1.0, d8) * d6;
            d5 = d / d6;
            d4 = d2 / d6;
            d3 = 1.0;
            if (Math.abs(d) > Math.abs(d2)) {
                d3 = d4;
            }
            if (Math.abs(d2) >= Math.abs(d) && d5 != 0.0) {
                d3 = 1.0 / d5;
            }
        } else {
            d5 = 1.0;
            d4 = 0.0;
            d6 = 0.0;
            d3 = 0.0;
        }
        d = d6;
        d2 = d3;
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d5;
        dArray[3] = d4;
    }

    public void dscal(double d, DoubleMatrix1D doubleMatrix1D) {
        doubleMatrix1D.assign(Functions.mult(d));
    }

    public void dswap(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.swap(doubleMatrix1D);
    }

    public void dsymv(boolean bl, double d, DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, double d2, DoubleMatrix1D doubleMatrix1D2) {
        if (bl) {
            doubleMatrix2D = doubleMatrix2D.viewDice();
        }
        Property.DEFAULT.checkSquare(doubleMatrix2D);
        int n = doubleMatrix2D.rows();
        if (n != doubleMatrix1D.size() || n != doubleMatrix1D2.size()) {
            throw new IllegalArgumentException(doubleMatrix2D.toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D.like();
        int n2 = 0;
        while (n2 < n) {
            double d3 = 0.0;
            int n3 = 0;
            while (n3 <= n2) {
                d3 += doubleMatrix2D.getQuick(n2, n3) * doubleMatrix1D.getQuick(n3);
                ++n3;
            }
            int n4 = n2 + 1;
            while (n4 < n) {
                d3 += doubleMatrix2D.getQuick(n4, n2) * doubleMatrix1D.getQuick(n4);
                ++n4;
            }
            doubleMatrix1D3.setQuick(n2, d * d3 + d2 * doubleMatrix1D2.getQuick(n2));
            ++n2;
        }
        doubleMatrix1D2.assign(doubleMatrix1D3);
    }

    public void dtrmv(boolean bl, boolean bl2, boolean bl3, DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        int n;
        if (bl2) {
            doubleMatrix2D = doubleMatrix2D.viewDice();
            bl = !bl;
        }
        Property.DEFAULT.checkSquare(doubleMatrix2D);
        int n2 = doubleMatrix2D.rows();
        if (n2 != doubleMatrix1D.size()) {
            throw new IllegalArgumentException(doubleMatrix2D.toStringShort() + ", " + doubleMatrix1D.toStringShort());
        }
        DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.like();
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D.like();
        if (bl3) {
            doubleMatrix1D3.assign(1.0);
        } else {
            n = 0;
            while (n < n2) {
                doubleMatrix1D3.setQuick(n, doubleMatrix2D.getQuick(n, n));
                ++n;
            }
        }
        n = 0;
        while (n < n2) {
            int n3;
            double d = 0.0;
            if (!bl) {
                n3 = 0;
                while (n3 < n) {
                    d += doubleMatrix2D.getQuick(n, n3) * doubleMatrix1D.getQuick(n3);
                    ++n3;
                }
                d += doubleMatrix1D3.getQuick(n) * doubleMatrix1D.getQuick(n);
            } else {
                d += doubleMatrix1D3.getQuick(n) * doubleMatrix1D.getQuick(n);
                n3 = n + 1;
                while (n3 < n2) {
                    d += doubleMatrix2D.getQuick(n3, n) * doubleMatrix1D.getQuick(n3);
                    ++n3;
                }
            }
            doubleMatrix1D2.setQuick(n, d);
            ++n;
        }
        doubleMatrix1D.assign(doubleMatrix1D2);
    }

    public int idamax(DoubleMatrix1D doubleMatrix1D) {
        int n = -1;
        double d = Double.MIN_VALUE;
        int n2 = doubleMatrix1D.size();
        while (--n2 >= 0) {
            double d2 = Math.abs(doubleMatrix1D.getQuick(n2));
            if (!(d2 > d)) continue;
            d = d2;
            n = n2;
        }
        return n;
    }

    private double sign(double d, double d2) {
        if (d2 < 0.0) {
            return -Math.abs(d);
        }
        return Math.abs(d);
    }
}

