## ----install, eval=FALSE------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# BiocManager::install("notameViz")

## ----setup, message = FALSE---------------------------------------------------
library(notame)
library(notameViz)
library(notameStats)

ppath <- tempdir()
init_log(log_file = file.path(ppath, "log.txt"))

data(hilic_neg_sample, package = "notame")
data(toy_notame_set, package = "notame")

## -----------------------------------------------------------------------------
plot_sample_boxplots(hilic_neg_sample, order_by = "Group", fill_by = "Group")

## -----------------------------------------------------------------------------
lm_results <- notameStats::perform_lm(notame::drop_qcs(toy_notame_set), 
  formula_char = "Feature ~ Group")

with_results <- notame::join_rowData(toy_notame_set, lm_results)

p <- volcano_plot(with_results,
  x = "GroupB.estimate", p = "GroupB.p.value", p_fdr = "GroupB.p.value_FDR")

# save_plot(p, file = "volcano_plot.pdf")

p 

## -----------------------------------------------------------------------------
beeswarm_list <- save_beeswarm_plots(toy_notame_set[1:10],
  save = FALSE, x = "Group", color = "Group")
  
beeswarm_list[[1]]

## ----echo = FALSE, results = 'markup'-----------------------------------------
sessionInfo()

