## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  prompt = TRUE,
  comment = NA
)
options(digits=4)

## ----sim----------------------------------------------------------------------
library(limpa)
set.seed(20241230)
y.prec <- simProteinDataSet()

## ----meanNA-------------------------------------------------------------------
dim(y.prec)
head(y.prec$genes)
table(y.prec$targets$Group)
mean(is.na(y.prec$E))

## ----dpc----------------------------------------------------------------------
dpcest <- dpc(y.prec)
dpcest$dpc
plotDPC(dpcest)

## ----dpcQuant-----------------------------------------------------------------
y.protein <- dpcQuant(y.prec, "Protein", dpc=dpcest)

## ----plotMDS------------------------------------------------------------------
plotMDSUsingSEs(y.protein)
Group <- factor(y.prec$targets$Group)
Group.color <- Group
levels(Group.color) <- c("blue","red")
plotMDSUsingSEs(y.protein, pch=16, col=as.character(Group.color))

## ----dpcDE--------------------------------------------------------------------
design <- model.matrix(~Group)
fit <- dpcDE(y.protein, design, plot=TRUE)

## ----eBayes-------------------------------------------------------------------
fit <- eBayes(fit)
topTable(fit, coef=2)

## ----plotProtein--------------------------------------------------------------
plotProtein(y.protein, "Protein23", col=as.character(Group.color))

## ----eval = FALSE-------------------------------------------------------------
# y.prec <- readDIANN("Report.tsv")

## ----eval = FALSE-------------------------------------------------------------
# y.prec <- readDIANN("Report.parquet")

## ----eval = FALSE-------------------------------------------------------------
# y.prec <- readDIANN("Report.tsv",
#              q.columns = c("Q.Value","Lib.Q.Value","Lib.PG.Q.Value"),
#              q.cutoffs = 0.01)

## ----eval = FALSE-------------------------------------------------------------
# y.prec <- readDIANN("Report.tsv",
#              q.columns = c("Q.Value","Global.Q.Value","Global.PG.Q.Value"),
#              q.cutoffs = 0.01)

## ----eval = FALSE-------------------------------------------------------------
# y.prec <- filterNonProteotypicPeptides(y.prec)

## ----eval = FALSE-------------------------------------------------------------
# y.prec <- filterCompoundProteins(y.prec)

## ----eval = FALSE-------------------------------------------------------------
# y.prec <- filterSingletonPeptides(y.prec, min.n.peptides = 2)

