## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----warning=FALSE------------------------------------------------------------
library(lfa)
library(gcatest)
dim(sim_geno)
length(sim_trait)

## -----------------------------------------------------------------------------
LF <- lfa(sim_geno, 3)
dim(LF)

## -----------------------------------------------------------------------------
gcat_p <- gcat(sim_geno, LF, sim_trait)

## -----------------------------------------------------------------------------
gcat_p[1:5]

## ----fig.height = 3, fig.align = 'center'-------------------------------------
library(ggplot2)
dat <- data.frame(p = gcat_p[6:10000])
ggplot(dat, aes(p, after_stat(density))) + geom_histogram(binwidth=1/20) + theme_bw()

