/*
 * Decompiled with CFR 0.152.
 */
package reder.application.io;

import java.awt.geom.AffineTransform;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JPanel;
import org.jfree.svg.SVGGraphics2D;
import org.jfree.svg.SVGUnits;
import reder.application.GraphTask;

public class ExportSVG {
    private JPanel exportpanel = null;
    private String ioFileType;
    private String saveAddress;
    private String taskProgress = "running";

    public String getProgress() {
        return this.taskProgress;
    }

    public void inputAndGo(GraphTask drawpanel, String saveAddress, String ioFileType) throws IOException {
        this.exportpanel = drawpanel;
        this.ioFileType = ioFileType;
        this.saveAddress = saveAddress;
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals(this.ioFileType)) {
            this.saveAddress = saveAddress + "." + ioFileType;
        }
        try {
            this.drawSVG();
            this.taskProgress = "endload";
        }
        catch (IOException ex) {
            this.taskProgress = "halt";
        }
    }

    public void drawSVG() throws IOException {
        double scaleW = this.exportpanel.getWidth();
        double scaleH = this.exportpanel.getHeight();
        double inscale = 8.5 / (scaleW / 96.0);
        double cx = (scaleW *= inscale) / 2.0;
        double cy = (scaleH *= inscale) / 2.0;
        SVGGraphics2D g2 = new SVGGraphics2D(scaleW, scaleH, SVGUnits.PX);
        AffineTransform tr1 = g2.getTransform();
        tr1.translate(-cx, -cy);
        tr1.scale(inscale, inscale);
        tr1.translate(cx / inscale, cy / inscale);
        g2.setTransform(tr1);
        this.exportpanel.paint(g2);
        String fileContent = g2.getSVGDocument();
        FileOutputStream outputStream = new FileOutputStream(this.saveAddress);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");){
            out.write(fileContent);
            ((Writer)out).close();
        }
    }
}

