% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MultiPhenoDB.R
\name{filterGeneByTrait}
\alias{filterGeneByTrait}
\title{Filter the geneByTrait data.frame}
\usage{
filterGeneByTrait(origin = c("germline", "de novo", "inherited", "maternal",
  "paternal", "biparental", "uniparental"),
  clinicalSignificance = c("Pathogenic"), diseaseDb = c())
}
\arguments{
\item{origin}{the origin of the variants to be taken into account.
If NULL this filter is not applied.}

\item{clinicalSignificance}{the clinical significance of the
variants to be taken into account. If NULL this filter is not applied.}

\item{diseaseDb}{the DB on which to focuse
(e.g. "OMIM", "MedGen", "Orphanet", ...)}
}
\value{
An assocation data.frame with the following fields: \describe{
 \item{entrez}{the gene Entrez ID.}
 \item{db}{the trait DB.}
 \item{id}{the trait ID.}
}
}
\description{
Get gene/trait association according to the origin and
the clinical status of the associated variants.
}
\examples{
##########################
## Filter gene/trait association according to variant origin and clinical status
geneByTrait <- filterGeneByTrait()
head(geneByTrait)
## Get gene/HP association according to gene/trait and trait/HP association
## The filtering options are the same than for filterGeneByTrait().
hpByGene <- getHpByGene()
head(hpByGene)

}
\seealso{
\code{\link{getHpByGene}}, \code{\link{getGeneByHp}}
}

