/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.pairwise;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;

public class PwToMatrix {
    HashMap<String, HashMap<String, Float>> queryMap = new HashMap();
    HashSet<String> allrefSet = new HashSet();

    public void process(File infile) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(infile));
        Object prevSeqID = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#seqname") || !line.startsWith("@")) continue;
            String[] vals = line.split("\\t");
            String seqID = vals[0].substring(1);
            HashMap<String, Float> valueMap = this.queryMap.get(seqID);
            if (valueMap == null) {
                valueMap = new HashMap();
                this.queryMap.put(seqID, valueMap);
            }
            Float pct = Float.valueOf(Float.parseFloat(vals[4]));
            valueMap.put(vals[10], pct);
            this.allrefSet.add(vals[10]);
        }
        reader.close();
    }

    public void print(File outfile) throws FileNotFoundException, IOException {
        PrintStream outstream = new PrintStream(outfile);
        Object[] refArr = this.allrefSet.toArray();
        for (Object s : refArr) {
            outstream.print("\t" + s);
        }
        outstream.print("\n");
        for (String q : this.queryMap.keySet()) {
            HashMap<String, Float> valueMap = this.queryMap.get(q);
            outstream.print(q);
            for (Object s : refArr) {
                outstream.print("\t" + valueMap.get(s));
            }
            outstream.print("\n");
        }
        outstream.close();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        String usage = "Usage: out_matrix.txt in_pw1.txt in_pw2.txt ... \nin_pw.txt output from AlignmentTool pairwise-knn \ngenerate a square % identity matrix ";
        if (args.length < 2) {
            throw new RuntimeException(usage);
        }
        PwToMatrix theObj = new PwToMatrix();
        for (int i = 1; i < args.length; ++i) {
            theObj.process(new File(args[i]));
        }
        theObj.print(new File(args[0]));
    }
}

