/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers;

import edu.msu.cme.rdp.readseq.SequenceFormat;
import edu.msu.cme.rdp.readseq.readers.SeqReader;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class MemSeqReader<E extends Sequence>
implements SeqReader {
    private Iterator<E> seqs;

    public MemSeqReader(Iterator<E> seqs) {
        this.seqs = seqs;
    }

    public MemSeqReader(Collection<E> seqs) {
        this(seqs.iterator());
    }

    public MemSeqReader(E ... seqs) {
        this.seqs = Arrays.asList(seqs).iterator();
    }

    @Override
    public E readNextSequence() throws IOException {
        if (this.seqs != null && this.seqs.hasNext()) {
            return (E)((Sequence)this.seqs.next());
        }
        return null;
    }

    @Override
    public SequenceFormat getFormat() {
        return SequenceFormat.IN_MEMORY;
    }

    @Override
    public void close() throws IOException {
        this.seqs = null;
    }
}

