/*
 * Decompiled with CFR 0.152.
 */
package stats.glm;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import stats.glm.BasisFunction;

public class GLMRegressionModel
implements Serializable {
    static final long serialVersionUID = 1446279193066313590L;
    private List basisList;
    private DoubleMatrix2D Sigma;
    private DoubleMatrix1D mu;
    private double sigma;

    public GLMRegressionModel(List list, DoubleMatrix1D doubleMatrix1D, DoubleMatrix2D doubleMatrix2D, double d) {
        this.basisList = list;
        this.mu = doubleMatrix1D;
        this.Sigma = doubleMatrix2D;
        this.sigma = d;
    }

    public double estimate(Object object) {
        DoubleMatrix1D doubleMatrix1D = DoubleFactory1D.dense.make(this.basisList.size());
        int n = 0;
        while (n < this.basisList.size()) {
            BasisFunction basisFunction = (BasisFunction)this.basisList.get(n);
            doubleMatrix1D.set(n, basisFunction.evaluate(object));
            ++n;
        }
        return Algebra.DEFAULT.mult(doubleMatrix1D, this.mu);
    }

    public double variance(Object object) {
        Object object2;
        DoubleMatrix1D doubleMatrix1D = DoubleFactory1D.dense.make(this.basisList.size());
        int n = 0;
        while (n < this.basisList.size()) {
            object2 = (BasisFunction)this.basisList.get(n);
            doubleMatrix1D.set(n, object2.evaluate(object));
            ++n;
        }
        object2 = Algebra.DEFAULT;
        return Math.pow(this.sigma, 2.0) + ((Algebra)object2).mult(doubleMatrix1D, ((Algebra)object2).mult(this.Sigma, doubleMatrix1D));
    }

    public Collection getBasisFunctions() {
        return this.basisList;
    }

    public double getSigma() {
        return this.sigma;
    }

    public double getWeight(BasisFunction basisFunction) throws NoSuchElementException {
        int n = this.basisList.indexOf(basisFunction);
        if (n < 0) {
            throw new NoSuchElementException();
        }
        return this.mu.get(n);
    }
}

