/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.HashSet;
import java.util.Set;
import org.biojava.stats.svm.NestedKernel;

public class DiagonalAddKernel
extends NestedKernel {
    private Set posClass = new HashSet();
    private Set negClass = new HashSet();
    private double lambda = 1.0;

    public void addNeg(Object object) {
        this.negClass.add(object);
    }

    public void addPos(Object object) {
        this.posClass.add(object);
    }

    public double evaluate(Object object, Object object2) {
        double d = this.getNestedKernel().evaluate(object, object2);
        if (object == object2) {
            int n = 0;
            if (this.posClass.contains(object)) {
                n = this.posClass.size();
            } else if (this.negClass.contains(object)) {
                n = this.negClass.size();
            }
            d += this.getLambda() * (double)n / (double)(this.posClass.size() + this.negClass.size());
        }
        return d;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double d) {
        this.lambda = d;
    }

    public String toString() {
        return "DiagonalAdd K(a, b | l, s+, s-, k) = k(a, b) + d[a, b]; d[a, b] = { a != b, 0; a == b, l * {class(a == +), s+; class(a == -), s-} }; k = " + this.getNestedKernel().toString();
    }
}

