/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.Symbol;

class TranscriptionTable
implements ReversibleTranslationTable {
    TranscriptionTable() {
    }

    public Alphabet getSourceAlphabet() {
        return DNATools.getDNA();
    }

    public Alphabet getTargetAlphabet() {
        return RNATools.getRNA();
    }

    public Symbol translate(Symbol symbol) throws IllegalSymbolException {
        if (symbol == DNATools.t()) {
            return RNATools.u();
        }
        DNATools.getDNA().validate(symbol);
        return symbol;
    }

    public Symbol untranslate(Symbol symbol) throws IllegalSymbolException {
        if (symbol == RNATools.u()) {
            return DNATools.t();
        }
        RNATools.getRNA().validate(symbol);
        return symbol;
    }
}

