/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.MissingResourceException;
import org.apache.xerces.parsers.DOMParser;
import org.biojava.bio.BioError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Protease {
    static Document doc = null;
    public static String TRYPSIN;
    public static String LYS_C;
    public static String Arg_C;
    public static String ASP_N;
    public static String GLU_C_BICARB;
    public static String GLU_C_PHOS;
    public static String CHYMOTRYP;
    public static String CNBr;
    private static String cleavageResidues;
    private static String notCleaveResidues;
    private static boolean endoProtease;
    static /* synthetic */ Class class$org$biojava$bio$proteomics$Protease;

    static {
        try {
            InputStream inputStream = (class$org$biojava$bio$proteomics$Protease != null ? class$org$biojava$bio$proteomics$Protease : (class$org$biojava$bio$proteomics$Protease = Protease.class$("org.biojava.bio.proteomics.Protease"))).getClassLoader().getResourceAsStream("org/biojava/bio/proteomics/ProteaseManager.xml");
            if (inputStream == null) {
                throw new BioError("Couldn't locate ResidueProperties.xml.");
            }
            InputSource inputSource = new InputSource(inputStream);
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(inputSource);
            doc = dOMParser.getDocument();
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TRYPSIN = "Trypsin";
        LYS_C = "Lys-C";
        Arg_C = "Arg-C";
        ASP_N = "Asp-N";
        GLU_C_BICARB = "Glu-C-bicarbonate";
        GLU_C_PHOS = "Glu-C-phosphate";
        CHYMOTRYP = "Chymostrypsin";
        CNBr = "CNBr";
        cleavageResidues = "";
        notCleaveResidues = "";
        endoProtease = true;
    }

    public Protease() {
    }

    public Protease(String string, boolean bl) {
        cleavageResidues = string;
        endoProtease = bl;
        notCleaveResidues = "";
    }

    public Protease(String string, boolean bl, String string2) {
        cleavageResidues = string;
        endoProtease = bl;
        notCleaveResidues = string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getCleaveageResidues() {
        return cleavageResidues;
    }

    public String getNotCleaveResidues() {
        return notCleaveResidues;
    }

    public static Protease getProteaseByName(String string) {
        Protease protease = null;
        NodeList nodeList = doc.getDocumentElement().getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element;
            Node node = nodeList.item(n);
            if (node instanceof Element && (element = (Element)node).getNodeName().equals("protease") && element.getAttribute("name").equals(string)) {
                String string2 = null;
                String string3 = null;
                boolean bl = false;
                NodeList nodeList2 = element.getChildNodes();
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Node node2 = nodeList.item(n2);
                    if (node2 instanceof Element) {
                        Element element2 = (Element)node2;
                        String string4 = element2.getNodeName();
                        String string5 = element2.getFirstChild().getNodeValue();
                        if (string4.equals("cleaveRes")) {
                            string2 = string5;
                        } else if (string4.equals("exceptRes")) {
                            string3 = string5;
                        } else if (string4.equals("endo")) {
                            bl = new Boolean(string5);
                        }
                    }
                    ++n2;
                }
                if (string2 != null && string3 != null) {
                    protease = new Protease(string2, bl, string3);
                } else if (string2 != null && string3 == null) {
                    protease = new Protease(string2, bl);
                }
            }
            ++n;
        }
        return protease;
    }

    public static String[] getProteaseList() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = doc.getDocumentElement().getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element;
            object = nodeList.item(n);
            if (object instanceof Element && (element = (Element)object).getNodeName().equals("protease")) {
                String string = element.getAttribute("name");
                arrayList.add(string);
            }
            ++n;
        }
        object = new String[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    public boolean isEndoProtease() {
        return endoProtease;
    }
}

