/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.program.gff.GFFDocumentHandler;
import org.biojava.bio.program.gff.SimpleGFFRecord;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.Location;

public class SequencesAsGFF {
    private FeatureFilter filter = FeatureFilter.all;
    private boolean recurse = false;

    protected void doProcessSequence(Sequence sequence, GFFDocumentHandler gFFDocumentHandler, String string) throws BioException, BioException {
        Iterator iterator = sequence.filter(this.getFeatureFilter(), this.getRecurse()).features();
        while (iterator.hasNext()) {
            Object object;
            Feature feature = (Feature)iterator.next();
            SimpleGFFRecord simpleGFFRecord = new SimpleGFFRecord();
            simpleGFFRecord.setSeqName(string);
            simpleGFFRecord.setSource(feature.getSource());
            simpleGFFRecord.setFeature(feature.getType());
            Location location = feature.getLocation();
            simpleGFFRecord.setStart(location.getMin());
            simpleGFFRecord.setEnd(location.getMax());
            simpleGFFRecord.setScore(Double.NEGATIVE_INFINITY);
            simpleGFFRecord.setStrand(StrandedFeature.UNKNOWN);
            if (feature instanceof StrandedFeature) {
                object = (StrandedFeature)feature;
                if (object.getStrand() == StrandedFeature.POSITIVE) {
                    simpleGFFRecord.setStrand(StrandedFeature.POSITIVE);
                } else if (object.getStrand() == StrandedFeature.NEGATIVE) {
                    simpleGFFRecord.setStrand(StrandedFeature.NEGATIVE);
                }
            }
            simpleGFFRecord.setFrame(-1);
            object = feature.getAnnotation().asMap();
            Iterator iterator2 = object.keySet().iterator();
            while (iterator2.hasNext()) {
                ArrayList<Object> arrayList;
                Object k = iterator2.next();
                Object v = object.get(k);
                String string2 = k.toString();
                if (v instanceof List) {
                    arrayList = (ArrayList<Object>)v;
                } else {
                    arrayList = new ArrayList<Object>();
                    arrayList.add(v);
                }
                int n = 0;
                while (n < arrayList.size()) {
                    Object e = arrayList.get(n);
                    arrayList.set(n, e.toString());
                    ++n;
                }
                object.put(string2, arrayList);
            }
            simpleGFFRecord.setGroupAttributes((Map)object);
            simpleGFFRecord.setComment(null);
            gFFDocumentHandler.recordLine(simpleGFFRecord);
        }
    }

    public FeatureFilter getFeatureFilter() {
        return this.filter;
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    public void processDB(SequenceDB sequenceDB, GFFDocumentHandler gFFDocumentHandler) throws BioException, BioException {
        gFFDocumentHandler.startDocument("unknown:SequenceDB");
        Iterator iterator = sequenceDB.ids().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Sequence sequence = sequenceDB.getSequence(string);
            this.doProcessSequence(sequence, gFFDocumentHandler, string);
        }
        gFFDocumentHandler.endDocument();
    }

    public void processSequence(Sequence sequence, GFFDocumentHandler gFFDocumentHandler) throws BioException, BioException {
        gFFDocumentHandler.startDocument(sequence.getURN());
        this.doProcessSequence(sequence, gFFDocumentHandler, sequence.getName());
        gFFDocumentHandler.endDocument();
    }

    public void setFeatureFilter(FeatureFilter featureFilter) {
        this.filter = featureFilter;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }
}

