/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.dp.State;
import org.biojava.bio.symbol.IllegalSymbolException;

public class SimpleModelTrainer
extends SimpleDistributionTrainerContext
implements ModelTrainer,
Serializable {
    private Set models = new HashSet();

    public void registerModel(MarkovModel markovModel) {
        if (!this.models.contains(markovModel)) {
            Iterator iterator = markovModel.stateAlphabet().iterator();
            while (iterator.hasNext()) {
                Distribution distribution;
                State state = (State)iterator.next();
                try {
                    distribution = markovModel.getWeights(state);
                    this.registerDistribution(distribution);
                }
                catch (IllegalSymbolException illegalSymbolException) {
                    throw new BioError(illegalSymbolException, "Couldn't register states from model");
                }
                if (!(state instanceof EmissionState)) continue;
                distribution = ((EmissionState)state).getDistribution();
                this.registerDistribution(distribution);
            }
        }
    }
}

