/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.IgnoreCountsTrainer;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class GapDistribution
implements Distribution {
    private final Alphabet alpha;

    public GapDistribution(Alphabet alphabet) {
        this.alpha = alphabet;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public Distribution getNullModel() {
        return this;
    }

    public double getWeight(Symbol symbol) throws IllegalSymbolException {
        return symbol == AlphabetManager.getGapSymbol() ? 1.0 : 0.0;
    }

    public void registerWithTrainer(DistributionTrainerContext distributionTrainerContext) {
        distributionTrainerContext.registerTrainer(this, IgnoreCountsTrainer.getInstance());
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public Symbol sampleSymbol() {
        return AlphabetManager.getGapSymbol();
    }

    public void setNullModel(Distribution distribution) throws IllegalAlphabetException, ChangeVetoException {
        throw new ChangeVetoException("Can't change null model for GapDistribution");
    }

    public void setWeight(Symbol symbol, double d) throws IllegalSymbolException, UnsupportedOperationException {
        this.getAlphabet().validate(symbol);
        throw new UnsupportedOperationException("The weights are immutable: " + symbol.getName() + " -> " + d);
    }
}

