/*
 * Decompiled with CFR 0.152.
 */
package eponine;

import com.sun.xml.parser.Resolver;
import com.sun.xml.tree.XmlDocument;
import eponine.model.EponineXML;
import eponine.model.FastModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.xml.AppEntry;
import org.xml.sax.InputSource;
import stats.glm.GLMClassificationModel;

public class ScanCore
implements AppEntry {
    private String fileName;
    private String seqName;
    private SequenceFormat seqFormat;
    private double threshold = 0.999;
    private int clusterTolerance;
    private boolean reverse = false;

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setSeqName(String string) {
        this.seqName = string;
    }

    public void setSeqFormat(SequenceFormat sequenceFormat) {
        this.seqFormat = sequenceFormat;
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    public void setClusterTolerance(int n) {
        this.clusterTolerance = n;
    }

    public void setReverse(boolean bl) {
        this.reverse = bl;
    }

    public void start(String[] stringArray) {
        try {
            EponineXML eponineXML = new EponineXML();
            InputSource inputSource = Resolver.createInputSource((File)new File(this.fileName));
            XmlDocument xmlDocument = XmlDocument.createXmlDocument((InputSource)inputSource, (boolean)false);
            GLMClassificationModel gLMClassificationModel = eponineXML.xmlToModel(xmlDocument.getDocumentElement());
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.seqName));
            StreamReader streamReader = new StreamReader(bufferedReader, this.seqFormat, DNATools.getDNA().getParser("token"), SimpleSequenceBuilder.FACTORY);
            SymbolList symbolList = streamReader.nextSequence();
            if (this.reverse) {
                symbolList = DNATools.reverseComplement(symbolList);
            }
            int n = symbolList.length();
            FastModel fastModel = new FastModel(gLMClassificationModel, symbolList, 1000);
            int n2 = -1000;
            int n3 = -1000;
            double d = 0.0;
            int n4 = 1;
            while (n4 < n) {
                double d2 = fastModel.score(n4);
                if (d2 > this.threshold) {
                    d = Math.max(d, d2);
                    n2 = n4;
                    if (n3 < 0) {
                        n3 = n4;
                    }
                } else if (n2 > 0 && n4 - n2 > this.clusterTolerance) {
                    if (this.reverse) {
                        n3 = symbolList.length() - n3 + 2;
                        n2 = symbolList.length() - n2 + 2;
                        System.out.println("" + n2 + " - " + n3 + " (" + d + ")");
                    } else {
                        System.out.println("" + n3 + " - " + n2 + " (" + d + ")");
                    }
                    n2 = -1000;
                    n3 = -1000;
                    d = 0.0;
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

