/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.sampling;

import cern.colt.PersistentObject;
import cern.colt.list.BooleanArrayList;
import cern.colt.list.IntArrayList;
import cern.jet.random.AbstractDistribution;
import cern.jet.random.Uniform;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class WeightedRandomSampler
extends PersistentObject {
    protected int skip;
    protected int nextTriggerPos;
    protected int nextSkip;
    protected int weight;
    protected Uniform generator;
    static final int UNDEFINED = -1;

    public WeightedRandomSampler() {
        this(1, null);
    }

    public WeightedRandomSampler(int n, RandomElement randomElement) {
        if (randomElement == null) {
            randomElement = AbstractDistribution.makeDefaultGenerator();
        }
        this.generator = new Uniform(randomElement);
        this.setWeight(n);
    }

    public Object clone() {
        WeightedRandomSampler weightedRandomSampler = (WeightedRandomSampler)super.clone();
        weightedRandomSampler.generator = (Uniform)this.generator.clone();
        return weightedRandomSampler;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean sampleNextElement() {
        if (this.skip > 0) {
            --this.skip;
            return false;
        }
        if (this.nextTriggerPos == -1) {
            this.nextTriggerPos = this.weight == 1 ? 0 : this.generator.nextIntFromTo(0, this.weight - 1);
            this.nextSkip = this.weight - 1 - this.nextTriggerPos;
        }
        if (this.nextTriggerPos > 0) {
            --this.nextTriggerPos;
            return false;
        }
        this.nextTriggerPos = -1;
        this.skip = this.nextSkip;
        return true;
    }

    public void setWeight(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("bad weight");
        }
        this.weight = n;
        this.skip = 0;
        this.nextTriggerPos = -1;
        this.nextSkip = 0;
    }

    public static void test(int n, int n2) {
        WeightedRandomSampler weightedRandomSampler = new WeightedRandomSampler();
        weightedRandomSampler.setWeight(n);
        IntArrayList intArrayList = new IntArrayList();
        int n3 = 0;
        while (n3 < n2) {
            if (weightedRandomSampler.sampleNextElement()) {
                intArrayList.add(n3);
            }
            ++n3;
        }
        System.out.println("Sample = " + intArrayList);
    }

    private void xsampleNextElements(BooleanArrayList booleanArrayList) {
        int n = booleanArrayList.size();
        boolean[] blArray = booleanArrayList.elements();
        int n2 = 0;
        while (n2 < n) {
            if (this.skip > 0) {
                --this.skip;
                blArray[n2] = false;
            } else {
                if (this.nextTriggerPos == -1) {
                    this.nextTriggerPos = this.weight == 1 ? 0 : this.generator.nextIntFromTo(0, this.weight - 1);
                    this.nextSkip = this.weight - 1 - this.nextTriggerPos;
                }
                if (this.nextTriggerPos > 0) {
                    --this.nextTriggerPos;
                    blArray[n2] = false;
                } else {
                    this.nextTriggerPos = -1;
                    this.skip = this.nextSkip;
                    blArray[n2] = true;
                }
            }
            ++n2;
        }
    }
}

