/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.PersistentObject;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.DenseObjectMatrix2D;
import cern.colt.matrix.impl.SparseObjectMatrix2D;

public class ObjectFactory2D
extends PersistentObject {
    public static final ObjectFactory2D dense = new ObjectFactory2D();
    public static final ObjectFactory2D sparse = new ObjectFactory2D();

    protected ObjectFactory2D() {
    }

    public ObjectMatrix2D appendColumns(ObjectMatrix2D objectMatrix2D, ObjectMatrix2D objectMatrix2D2) {
        if (objectMatrix2D2.rows() > objectMatrix2D.rows()) {
            objectMatrix2D2 = objectMatrix2D2.viewPart(0, 0, objectMatrix2D.rows(), objectMatrix2D2.columns());
        } else if (objectMatrix2D2.rows() < objectMatrix2D.rows()) {
            objectMatrix2D = objectMatrix2D.viewPart(0, 0, objectMatrix2D2.rows(), objectMatrix2D.columns());
        }
        int n = objectMatrix2D.columns();
        int n2 = objectMatrix2D2.columns();
        int n3 = objectMatrix2D.rows();
        ObjectMatrix2D objectMatrix2D3 = this.make(n3, n + n2);
        objectMatrix2D3.viewPart(0, 0, n3, n).assign(objectMatrix2D);
        objectMatrix2D3.viewPart(0, n, n3, n2).assign(objectMatrix2D2);
        return objectMatrix2D3;
    }

    public ObjectMatrix2D appendRows(ObjectMatrix2D objectMatrix2D, ObjectMatrix2D objectMatrix2D2) {
        if (objectMatrix2D2.columns() > objectMatrix2D.columns()) {
            objectMatrix2D2 = objectMatrix2D2.viewPart(0, 0, objectMatrix2D2.rows(), objectMatrix2D.columns());
        } else if (objectMatrix2D2.columns() < objectMatrix2D.columns()) {
            objectMatrix2D = objectMatrix2D.viewPart(0, 0, objectMatrix2D.rows(), objectMatrix2D2.columns());
        }
        int n = objectMatrix2D.rows();
        int n2 = objectMatrix2D2.rows();
        int n3 = objectMatrix2D.columns();
        ObjectMatrix2D objectMatrix2D3 = this.make(n + n2, n3);
        objectMatrix2D3.viewPart(0, 0, n, n3).assign(objectMatrix2D);
        objectMatrix2D3.viewPart(n, 0, n2, n3).assign(objectMatrix2D2);
        return objectMatrix2D3;
    }

    protected static void checkRectangularShape(ObjectMatrix2D[][] objectMatrix2DArray) {
        int n = -1;
        int n2 = objectMatrix2DArray.length;
        while (--n2 >= 0) {
            if (objectMatrix2DArray[n2] == null) continue;
            if (n == -1) {
                n = objectMatrix2DArray[n2].length;
            }
            if (objectMatrix2DArray[n2].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(Object[][] objectArray) {
        int n = -1;
        int n2 = objectArray.length;
        while (--n2 >= 0) {
            if (objectArray[n2] == null) continue;
            if (n == -1) {
                n = objectArray[n2].length;
            }
            if (objectArray[n2].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public ObjectMatrix2D compose(ObjectMatrix2D[][] objectMatrix2DArray) {
        int n;
        int n2;
        int n3;
        ObjectFactory2D.checkRectangularShape(objectMatrix2DArray);
        int n4 = objectMatrix2DArray.length;
        int n5 = 0;
        if (objectMatrix2DArray.length > 0) {
            n5 = objectMatrix2DArray[0].length;
        }
        ObjectMatrix2D objectMatrix2D = this.make(0, 0);
        if (n4 == 0 || n5 == 0) {
            return objectMatrix2D;
        }
        int[] nArray = new int[n5];
        int n6 = n5;
        while (--n6 >= 0) {
            int n7 = 0;
            n3 = n4;
            while (--n3 >= 0) {
                ObjectMatrix2D objectMatrix2D2 = objectMatrix2DArray[n3][n6];
                if (objectMatrix2D2 == null) continue;
                n2 = objectMatrix2D2.columns();
                if (n7 > 0 && n2 > 0 && n2 != n7) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n7 = Math.max(n7, n2);
            }
            nArray[n6] = n7;
        }
        int[] nArray2 = new int[n4];
        n3 = n4;
        while (--n3 >= 0) {
            int n8 = 0;
            n2 = n5;
            while (--n2 >= 0) {
                ObjectMatrix2D objectMatrix2D3 = objectMatrix2DArray[n3][n2];
                if (objectMatrix2D3 == null) continue;
                n = objectMatrix2D3.rows();
                if (n8 > 0 && n > 0 && n != n8) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n8 = Math.max(n8, n);
            }
            nArray2[n3] = n8;
        }
        int n9 = 0;
        n2 = n4;
        while (--n2 >= 0) {
            n9 += nArray2[n2];
        }
        int n10 = 0;
        n = n5;
        while (--n >= 0) {
            n10 += nArray[n];
        }
        ObjectMatrix2D objectMatrix2D4 = this.make(n9, n10);
        int n11 = 0;
        int n12 = 0;
        while (n12 < n4) {
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                ObjectMatrix2D objectMatrix2D5 = objectMatrix2DArray[n12][n14];
                if (objectMatrix2D5 != null) {
                    objectMatrix2D4.viewPart(n11, n13, objectMatrix2D5.rows(), objectMatrix2D5.columns()).assign(objectMatrix2D5);
                }
                n13 += nArray[n14];
                ++n14;
            }
            n11 += nArray2[n12];
            ++n12;
        }
        return objectMatrix2D4;
    }

    public ObjectMatrix2D composeDiagonal(ObjectMatrix2D objectMatrix2D, ObjectMatrix2D objectMatrix2D2) {
        int n = objectMatrix2D.rows();
        int n2 = objectMatrix2D.columns();
        int n3 = objectMatrix2D2.rows();
        int n4 = objectMatrix2D2.columns();
        ObjectMatrix2D objectMatrix2D3 = this.make(n + n3, n2 + n4);
        objectMatrix2D3.viewPart(0, 0, n, n2).assign(objectMatrix2D);
        objectMatrix2D3.viewPart(n, n2, n3, n4).assign(objectMatrix2D2);
        return objectMatrix2D3;
    }

    public ObjectMatrix2D composeDiagonal(ObjectMatrix2D objectMatrix2D, ObjectMatrix2D objectMatrix2D2, ObjectMatrix2D objectMatrix2D3) {
        ObjectMatrix2D objectMatrix2D4 = this.make(objectMatrix2D.rows() + objectMatrix2D2.rows() + objectMatrix2D3.rows(), objectMatrix2D.columns() + objectMatrix2D2.columns() + objectMatrix2D3.columns());
        objectMatrix2D4.viewPart(0, 0, objectMatrix2D.rows(), objectMatrix2D.columns()).assign(objectMatrix2D);
        objectMatrix2D4.viewPart(objectMatrix2D.rows(), objectMatrix2D.columns(), objectMatrix2D2.rows(), objectMatrix2D2.columns()).assign(objectMatrix2D2);
        objectMatrix2D4.viewPart(objectMatrix2D.rows() + objectMatrix2D2.rows(), objectMatrix2D.columns() + objectMatrix2D2.columns(), objectMatrix2D3.rows(), objectMatrix2D3.columns()).assign(objectMatrix2D3);
        return objectMatrix2D4;
    }

    public void decompose(ObjectMatrix2D[][] objectMatrix2DArray, ObjectMatrix2D objectMatrix2D) {
        int n;
        int n2;
        int n3;
        ObjectFactory2D.checkRectangularShape(objectMatrix2DArray);
        int n4 = objectMatrix2DArray.length;
        int n5 = 0;
        if (objectMatrix2DArray.length > 0) {
            n5 = objectMatrix2DArray[0].length;
        }
        if (n4 == 0 || n5 == 0) {
            return;
        }
        int[] nArray = new int[n5];
        int n6 = n5;
        while (--n6 >= 0) {
            int n7 = 0;
            n3 = n4;
            while (--n3 >= 0) {
                ObjectMatrix2D objectMatrix2D2 = objectMatrix2DArray[n3][n6];
                if (objectMatrix2D2 == null) continue;
                n2 = objectMatrix2D2.columns();
                if (n7 > 0 && n2 > 0 && n2 != n7) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n7 = Math.max(n7, n2);
            }
            nArray[n6] = n7;
        }
        int[] nArray2 = new int[n4];
        n3 = n4;
        while (--n3 >= 0) {
            int n8 = 0;
            n2 = n5;
            while (--n2 >= 0) {
                ObjectMatrix2D objectMatrix2D3 = objectMatrix2DArray[n3][n2];
                if (objectMatrix2D3 == null) continue;
                n = objectMatrix2D3.rows();
                if (n8 > 0 && n > 0 && n != n8) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n8 = Math.max(n8, n);
            }
            nArray2[n3] = n8;
        }
        int n9 = 0;
        n2 = n4;
        while (--n2 >= 0) {
            n9 += nArray2[n2];
        }
        int n10 = 0;
        n = n5;
        while (--n >= 0) {
            n10 += nArray[n];
        }
        if (objectMatrix2D.rows() < n9 || objectMatrix2D.columns() < n10) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        int n11 = 0;
        int n12 = 0;
        while (n12 < n4) {
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                ObjectMatrix2D objectMatrix2D4 = objectMatrix2DArray[n12][n14];
                if (objectMatrix2D4 != null) {
                    objectMatrix2D4.assign(objectMatrix2D.viewPart(n11, n13, objectMatrix2D4.rows(), objectMatrix2D4.columns()));
                }
                n13 += nArray[n14];
                ++n14;
            }
            n11 += nArray2[n12];
            ++n12;
        }
    }

    public ObjectMatrix2D diagonal(ObjectMatrix1D objectMatrix1D) {
        int n = objectMatrix1D.size();
        ObjectMatrix2D objectMatrix2D = this.make(n, n);
        int n2 = n;
        while (--n2 >= 0) {
            objectMatrix2D.setQuick(n2, n2, objectMatrix1D.getQuick(n2));
        }
        return objectMatrix2D;
    }

    public ObjectMatrix1D diagonal(ObjectMatrix2D objectMatrix2D) {
        int n = Math.min(objectMatrix2D.rows(), objectMatrix2D.columns());
        ObjectMatrix1D objectMatrix1D = this.make1D(n);
        int n2 = n;
        while (--n2 >= 0) {
            objectMatrix1D.setQuick(n2, objectMatrix2D.getQuick(n2, n2));
        }
        return objectMatrix1D;
    }

    public ObjectMatrix2D make(Object[][] objectArray) {
        if (this == sparse) {
            return new SparseObjectMatrix2D(objectArray);
        }
        return new DenseObjectMatrix2D(objectArray);
    }

    public ObjectMatrix2D make(Object[] objectArray, int n) {
        int n2;
        int n3 = n2 = n != 0 ? objectArray.length / n : 0;
        if (n * n2 != objectArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        ObjectMatrix2D objectMatrix2D = this.make(n, n2);
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                objectMatrix2D.setQuick(n4, n5, objectArray[n4 + n5 * n]);
                ++n5;
            }
            ++n4;
        }
        return objectMatrix2D;
    }

    public ObjectMatrix2D make(int n, int n2) {
        if (this == sparse) {
            return new SparseObjectMatrix2D(n, n2);
        }
        return new DenseObjectMatrix2D(n, n2);
    }

    public ObjectMatrix2D make(int n, int n2, Object object) {
        if (object == null) {
            return this.make(n, n2);
        }
        return this.make(n, n2).assign(object);
    }

    protected ObjectMatrix1D make1D(int n) {
        return this.make(0, 0).like1D(n);
    }

    public ObjectMatrix2D repeat(ObjectMatrix2D objectMatrix2D, int n, int n2) {
        int n3 = objectMatrix2D.rows();
        int n4 = objectMatrix2D.columns();
        ObjectMatrix2D objectMatrix2D2 = this.make(n3 * n, n4 * n2);
        int n5 = n;
        while (--n5 >= 0) {
            int n6 = n2;
            while (--n6 >= 0) {
                objectMatrix2D2.viewPart(n3 * n5, n4 * n6, n3, n4).assign(objectMatrix2D);
            }
        }
        return objectMatrix2D2;
    }
}

