## ----style, echo = FALSE, results = 'asis'------------------------------------
BiocStyle::markdown()

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, warning = FALSE, message = FALSE)

## ----env----------------------------------------------------------------------
library("omXplore")

## ----meta_mae, echo = TRUE----------------------------------------------------
data(vdata)
MultiAssayExperiment::metadata(vdata)

## ----meta_se, echo = TRUE-----------------------------------------------------
data(vdata)
MultiAssayExperiment::metadata(vdata[[1]])

## ----listShinyApps------------------------------------------------------------
listPlotModules()

## ----ex_modules, eval=FALSE---------------------------------------------------
# data(sub_R25)
# app <- omXplore_density(sub_R25, 1)
# shiny::runApp(app)

## ----omXplore_density_png, results='markup', fig.cap="Plot generated by the module omXplore_density()", echo=FALSE, out.width='100%', fig.align='center', fig.wide = TRUE----
knitr::include_graphics("./figs/omXplore_density.png", error = FALSE)

## ----view_dataset_modal, eval=FALSE-------------------------------------------
# data(sub_R25)
# app <- view_dataset(sub_R25)
# shiny::runApp(app)

## ----example_view_dataset_nomodal_png, results='markup', fig.cap="`omXplore` interactive interface with modal.", echo=FALSE, out.width='100%', fig.align='center', fig.wide = TRUE----
knitr::include_graphics("./figs/example_view_dataset_nomodal.png", error = FALSE)

## ----view_dataset_nomodal_png, results='markup', fig.cap="`omXplore` interactive interface with modal.", echo=FALSE, out.width='100%', fig.align='center', fig.wide = TRUE----
knitr::include_graphics("./figs/view_dataset_modal.png", error = FALSE)

## -----------------------------------------------------------------------------
sessionInfo()

