/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.Random;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomSubset
implements Iterator<Integer> {
    private Random prng;
    private int N;
    private int M;
    private Helper helper;

    public RandomSubset(Random random, int n) {
        this(random, n, false);
    }

    public RandomSubset(Random random, int n, boolean bl) {
        if (random == null) {
            throw new NullPointerException("RandomSubset(): prng is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("RandomSubset(): N = " + n + " illegal");
        }
        this.prng = random;
        this.N = n;
        this.helper = bl ? new DenseHelper() : new SparseHelper();
    }

    @Override
    public boolean hasNext() {
        return this.M < this.N;
    }

    @Override
    public Integer next() {
        if (this.M >= this.N) {
            throw new NoSuchElementException("RandomSubset.next(): No further elements");
        }
        this.helper.swapElements(this.M, this.M + this.prng.nextInt(this.N - this.M));
        ++this.M;
        return this.helper.getElement(this.M - 1);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public RandomSubset remove(int n) {
        if (0 > n || n >= this.N) {
            throw new IllegalArgumentException("RandomSubset.remove(): i = " + n + " illegal");
        }
        int n2 = this.helper.indexOf(n);
        if (n2 >= this.M) {
            this.helper.swapElements(this.M, n2);
            ++this.M;
        }
        return this;
    }

    public void restart() {
        this.M = 0;
        this.helper.restart();
    }

    private class DenseHelper
    extends Helper {
        private int[] permutation;

        public DenseHelper() {
            this.permutation = new int[RandomSubset.this.N];
            this.restart();
        }

        public int getElement(int n) {
            return this.permutation[n];
        }

        public void setElement(int n, int n2) {
            this.permutation[n] = n2;
        }

        public void swapElements(int n, int n2) {
            int n3 = this.permutation[n];
            this.permutation[n] = this.permutation[n2];
            this.permutation[n2] = n3;
        }

        public int indexOf(int n) {
            int n2 = 0;
            while (this.permutation[n2] != n) {
                ++n2;
            }
            return n2;
        }

        public void restart() {
            for (int i = 0; i < RandomSubset.this.N; ++i) {
                this.permutation[i] = i;
            }
        }
    }

    private class SparseHelper
    extends Helper {
        private HashMap<Integer, Integer> permutation;

        private SparseHelper() {
            this.permutation = new HashMap();
        }

        public int getElement(int n) {
            Integer n2 = this.permutation.get(n);
            return n2 == null ? n : n2;
        }

        public void setElement(int n, int n2) {
            if (n2 == n) {
                this.permutation.remove(n);
            } else {
                this.permutation.put(n, n2);
            }
        }

        public void swapElements(int n, int n2) {
            int n3 = this.getElement(n);
            this.setElement(n, this.getElement(n2));
            this.setElement(n2, n3);
        }

        public int indexOf(int n) {
            for (Map.Entry<Integer, Integer> entry : this.permutation.entrySet()) {
                if (entry.getValue() != n) continue;
                return entry.getKey();
            }
            return n;
        }

        public void restart() {
            this.permutation.clear();
        }
    }

    private abstract class Helper {
        private Helper() {
        }

        public abstract int getElement(int var1);

        public abstract void setElement(int var1, int var2);

        public abstract void swapElements(int var1, int var2);

        public abstract int indexOf(int var1);

        public abstract void restart();
    }
}

