/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.monte;

import edu.rit.pj.LongForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedLong;
import edu.rit.util.Random;

public class PiSmp3 {
    static long seed;
    static long N;
    static SharedLong count;

    private PiSmp3() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        if (stringArray.length != 2) {
            PiSmp3.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        N = Long.parseLong(stringArray[1]);
        count = new SharedLong(0L);
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                this.execute(0L, N - 1L, new LongForLoop(){
                    Random prng_thread = Random.getInstance(seed);
                    long count_thread = 0L;
                    long p0;
                    long p1;
                    long p2;
                    long p3;
                    long p4;
                    long p5;
                    long p6;
                    long p7;
                    long p8;
                    long p9;
                    long pa;
                    long pb;
                    long pc;
                    long pd;
                    long pe;
                    long pf;

                    public void run(long l, long l2) {
                        this.prng_thread.setSeed(seed);
                        this.prng_thread.skip(2L * l);
                        for (long i = l; i <= l2; ++i) {
                            double d;
                            double d2 = this.prng_thread.nextDouble();
                            if (!(d2 * d2 + (d = this.prng_thread.nextDouble()) * d <= 1.0)) continue;
                            ++this.count_thread;
                        }
                    }

                    public void finish() {
                        count.addAndGet(this.count_thread);
                    }
                });
            }
        });
        System.out.println("pi = 4 * " + count + " / " + N + " = " + 4.0 * count.doubleValue() / (double)N);
        System.out.println((l += System.currentTimeMillis()) + " msec");
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.nt=<K> edu.rit.smp.monte.PiSmp3 <seed> <N>");
        System.err.println("<K> = Number of parallel threads");
        System.err.println("<seed> = Random seed");
        System.err.println("<N> = Number of random points");
        System.exit(1);
    }
}

