/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.keysearch;

import edu.rit.crypto.blockcipher.AES256Cipher;
import edu.rit.util.Hex;

public class FindKeySeq {
    static byte[] plaintext;
    static byte[] ciphertext;
    static byte[] partialkey;
    static int n;
    static int keylsbs;
    static int maxcounter;
    static byte[] foundkey;
    static byte[] trialkey;
    static byte[] trialciphertext;
    static AES256Cipher cipher;

    private FindKeySeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        if (stringArray.length != 4) {
            FindKeySeq.usage();
        }
        plaintext = Hex.toByteArray(stringArray[0]);
        ciphertext = Hex.toByteArray(stringArray[1]);
        partialkey = Hex.toByteArray(stringArray[2]);
        n = Integer.parseInt(stringArray[3]);
        if (n < 0) {
            System.err.println("n = " + n + " is too small");
            System.exit(1);
        }
        if (n > 30) {
            System.err.println("n = " + n + " is too large");
            System.exit(1);
        }
        keylsbs = (partialkey[28] & 0xFF) << 24 | (partialkey[29] & 0xFF) << 16 | (partialkey[30] & 0xFF) << 8 | partialkey[31] & 0xFF;
        maxcounter = (1 << n) - 1;
        trialkey = new byte[32];
        System.arraycopy(partialkey, 0, trialkey, 0, 32);
        trialciphertext = new byte[16];
        cipher = new AES256Cipher(trialkey);
        for (int i = 0; i <= maxcounter; ++i) {
            int n = keylsbs | i;
            FindKeySeq.trialkey[28] = (byte)(n >>> 24);
            FindKeySeq.trialkey[29] = (byte)(n >>> 16);
            FindKeySeq.trialkey[30] = (byte)(n >>> 8);
            FindKeySeq.trialkey[31] = (byte)n;
            cipher.setKey(trialkey);
            cipher.encrypt(plaintext, trialciphertext);
            if (!FindKeySeq.match(ciphertext, trialciphertext)) continue;
            foundkey = new byte[32];
            System.arraycopy(trialkey, 0, foundkey, 0, 32);
        }
        long l2 = System.currentTimeMillis();
        System.out.println(Hex.toString(foundkey));
        System.out.println(l2 - l + " msec");
    }

    private static boolean match(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            bl = bl && byArray[i] == byArray2[i];
        }
        return bl;
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.smp.keysearch.FindKeySeq <plaintext> <ciphertext> <partialkey> <n>");
        System.err.println("<plaintext> = Plaintext (128-bit hexadecimal number)");
        System.err.println("<ciphertext> = Ciphertext (128-bit hexadecimal number)");
        System.err.println("<partialkey> = Partial key (256-bit hexadecimal number)");
        System.err.println("<n> = Number of key bits to search for");
        System.exit(1);
    }
}

