/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.DoubleOp;
import java.util.concurrent.atomic.AtomicLong;

public class SharedDouble
extends Number {
    private AtomicLong myValue;

    public SharedDouble() {
        this.myValue = new AtomicLong(Double.doubleToLongBits(0.0));
    }

    public SharedDouble(double d) {
        this.myValue = new AtomicLong(Double.doubleToLongBits(d));
    }

    public double get() {
        return Double.longBitsToDouble(this.myValue.get());
    }

    public void set(double d) {
        this.myValue.set(Double.doubleToLongBits(d));
    }

    public double getAndSet(double d) {
        return Double.longBitsToDouble(this.myValue.getAndSet(Double.doubleToLongBits(d)));
    }

    public boolean compareAndSet(double d, double d2) {
        return this.myValue.compareAndSet(Double.doubleToLongBits(d), Double.doubleToLongBits(d2));
    }

    public boolean weakCompareAndSet(double d, double d2) {
        return this.myValue.weakCompareAndSet(Double.doubleToLongBits(d), Double.doubleToLongBits(d2));
    }

    public double getAndIncrement() {
        double d;
        double d2;
        long l;
        long l2;
        while (!this.myValue.compareAndSet(l2 = this.myValue.get(), l = Double.doubleToLongBits(d2 = (d = Double.longBitsToDouble(l2)) + 1.0))) {
        }
        return d;
    }

    public double getAndDecrement() {
        double d;
        double d2;
        long l;
        long l2;
        while (!this.myValue.compareAndSet(l2 = this.myValue.get(), l = Double.doubleToLongBits(d2 = (d = Double.longBitsToDouble(l2)) - 1.0))) {
        }
        return d;
    }

    public double getAndAdd(double d) {
        double d2;
        double d3;
        long l;
        long l2;
        while (!this.myValue.compareAndSet(l2 = this.myValue.get(), l = Double.doubleToLongBits(d3 = (d2 = Double.longBitsToDouble(l2)) + d))) {
        }
        return d2;
    }

    public double incrementAndGet() {
        double d;
        double d2;
        long l;
        long l2;
        while (!this.myValue.compareAndSet(l2 = this.myValue.get(), l = Double.doubleToLongBits(d2 = (d = Double.longBitsToDouble(l2)) + 1.0))) {
        }
        return d2;
    }

    public double decrementAndGet() {
        double d;
        double d2;
        long l;
        long l2;
        while (!this.myValue.compareAndSet(l2 = this.myValue.get(), l = Double.doubleToLongBits(d2 = (d = Double.longBitsToDouble(l2)) - 1.0))) {
        }
        return d2;
    }

    public double addAndGet(double d) {
        double d2;
        double d3;
        long l;
        long l2;
        while (!this.myValue.compareAndSet(l2 = this.myValue.get(), l = Double.doubleToLongBits(d3 = (d2 = Double.longBitsToDouble(l2)) + d))) {
        }
        return d3;
    }

    public double reduce(double d, DoubleOp doubleOp) {
        double d2;
        double d3;
        long l;
        long l2;
        while (!this.myValue.compareAndSet(l2 = this.myValue.get(), l = Double.doubleToLongBits(d3 = doubleOp.op(d2 = Double.longBitsToDouble(l2), d)))) {
        }
        return d3;
    }

    public String toString() {
        return Double.toString(this.get());
    }

    public int intValue() {
        return (int)this.get();
    }

    public long longValue() {
        return (long)this.get();
    }

    public float floatValue() {
        return (float)this.get();
    }

    public double doubleValue() {
        return this.get();
    }
}

