/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.mp.ChannelGroup;
import edu.rit.mp.ChannelGroupClosedException;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.Status;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.cluster.BackendClassLoader;
import edu.rit.pj.cluster.BackendFileReader;
import edu.rit.pj.cluster.BackendFileWriter;
import edu.rit.pj.cluster.JobBackendMessage;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendProxy;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.ResourceCache;
import edu.rit.util.ByteSequence;
import edu.rit.util.Timer;
import edu.rit.util.TimerTask;
import edu.rit.util.TimerThread;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;

public class JobBackend
implements Runnable,
JobBackendRef {
    private static JobBackend theJobBackend;
    private String username;
    private int jobnum;
    private int K;
    private int rank;
    private boolean hasFrontendComm;
    private String frontendHost;
    private int frontendPort;
    private String backendHost;
    private TimerThread myLeaseTimerThread;
    private Timer myFrontendRenewTimer;
    private Timer myFrontendExpireTimer;
    private ChannelGroup myMiddlewareChannelGroup;
    private InetSocketAddress[] myMiddlewareAddress;
    private JobFrontendRef myJobFrontend;
    private ResourceCache myResourceCache;
    private BackendClassLoader myClassLoader;
    private ChannelGroup myWorldChannelGroup;
    private InetSocketAddress[] myWorldAddress;
    private ChannelGroup myFrontendChannelGroup;
    private InetSocketAddress[] myFrontendAddress;
    private Properties myProperties;
    private String myMainClassName;
    private String[] myArgs;
    private boolean commence;
    private ObjectItemBuf<JobBackendMessage> myBuffer = ObjectBuf.buffer((JobBackendMessage)null);
    private boolean continueRun = true;
    private CountDownLatch runFinished = new CountDownLatch(1);
    private State myState = State.RUNNING;
    private String myCancelMessage;
    private PrintStream myJobLauncherLog;
    private BackendFileWriter myFileWriter;
    private BackendFileReader myFileReader;

    private JobBackend(String string, int n, int n2, int n3, boolean bl, String string2, int n4, String string3) throws IOException {
        this.username = string;
        this.jobnum = n;
        this.K = n2;
        this.rank = n3;
        this.hasFrontendComm = bl;
        this.frontendHost = string2;
        this.frontendPort = n4;
        this.backendHost = string3;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JobBackend.this.shutdown();
            }
        });
        this.myLeaseTimerThread = new TimerThread();
        this.myLeaseTimerThread.setDaemon(true);
        this.myLeaseTimerThread.start();
        this.myFrontendRenewTimer = this.myLeaseTimerThread.createTimer(new TimerTask(){

            public void action(Timer timer) {
                try {
                    JobBackend.this.frontendRenewTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.myFrontendExpireTimer = this.myLeaseTimerThread.createTimer(new TimerTask(){

            public void action(Timer timer) {
                try {
                    JobBackend.this.frontendExpireTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.myFrontendExpireTimer.start(150000L);
        this.myMiddlewareChannelGroup = new ChannelGroup(new InetSocketAddress(string3, 0));
        this.myMiddlewareChannelGroup.startListening();
        this.myJobFrontend = new JobFrontendProxy(this.myMiddlewareChannelGroup, this.myMiddlewareChannelGroup.connect(new InetSocketAddress(string2, n4)));
        this.myFrontendRenewTimer.start(60000L, 60000L);
        this.myResourceCache = new ResourceCache();
        this.myClassLoader = new BackendClassLoader(this.getClass().getClassLoader(), this, this.myJobFrontend, this.myResourceCache);
        this.myWorldChannelGroup = new ChannelGroup(new InetSocketAddress(string3, 0));
        this.myWorldChannelGroup.setAlternateClassLoader(this.myClassLoader);
        if (bl) {
            this.myFrontendChannelGroup = new ChannelGroup(new InetSocketAddress(string3, 0));
            this.myFrontendChannelGroup.setAlternateClassLoader(this.myClassLoader);
        }
        this.myFileWriter = new BackendFileWriter(this.myJobFrontend, this);
        this.myFileReader = new BackendFileReader(this.myJobFrontend, this);
        System.in.close();
        System.out.close();
        this.myJobLauncherLog = System.err;
        System.setIn(this.myFileReader.in);
        System.setOut(this.myFileWriter.out);
        System.setErr(this.myFileWriter.err);
        this.myJobFrontend.backendReady(this, n3, this.myMiddlewareChannelGroup.listenAddress(), this.myWorldChannelGroup.listenAddress(), bl ? this.myFrontendChannelGroup.listenAddress() : null);
    }

    public void run() {
        Status status = null;
        JobBackendMessage jobBackendMessage = null;
        try {
            while (this.continueRun) {
                status = this.myMiddlewareChannelGroup.receive(null, null, this.myBuffer);
                jobBackendMessage = (JobBackendMessage)this.myBuffer.item;
                jobBackendMessage.invoke(this, this.myJobFrontend);
                this.myBuffer.item = null;
                status = null;
                jobBackendMessage = null;
            }
            this.reportRunFinished();
        }
        catch (ChannelGroupClosedException channelGroupClosedException) {
            this.reportRunFinished();
        }
        catch (Throwable throwable) {
            this.reportRunFinished();
            this.terminateCancelJob(throwable);
        }
        switch (this.myState) {
            case TERMINATE_CANCEL_JOB: 
            case TERMINATE_NO_REPORT: {
                System.exit(1);
                break;
            }
        }
    }

    public synchronized void cancelJob(JobFrontendRef jobFrontendRef, String string) throws IOException {
        this.terminateNoReport();
    }

    public synchronized void commenceJob(JobFrontendRef jobFrontendRef, InetSocketAddress[] inetSocketAddressArray, InetSocketAddress[] inetSocketAddressArray2, InetSocketAddress[] inetSocketAddressArray3, Properties properties, String string, String[] stringArray) throws IOException {
        this.myMiddlewareAddress = inetSocketAddressArray;
        this.myWorldAddress = inetSocketAddressArray2;
        this.myFrontendAddress = inetSocketAddressArray3;
        this.myProperties = properties;
        this.myMainClassName = string;
        this.myArgs = stringArray;
        this.commence = true;
        this.notifyAll();
    }

    public synchronized void jobFinished(JobFrontendRef jobFrontendRef) throws IOException {
        this.continueRun = false;
    }

    public synchronized void renewLease(JobFrontendRef jobFrontendRef) throws IOException {
        this.myFrontendExpireTimer.start(150000L);
    }

    public synchronized void reportResource(JobFrontendRef jobFrontendRef, String string, byte[] byArray) throws IOException {
        this.myResourceCache.put(string, byArray);
    }

    public synchronized void reportResource(JobFrontendRef jobFrontendRef, String string, ByteSequence byteSequence) throws IOException {
        this.myResourceCache.put(string, byteSequence == null ? null : byteSequence.toByteArray());
    }

    public synchronized void outputFileOpenResult(JobFrontendRef jobFrontendRef, int n, int n2, IOException iOException) throws IOException {
        this.myFileWriter.outputFileOpenResult(jobFrontendRef, n, n2, iOException);
    }

    public synchronized void outputFileWriteResult(JobFrontendRef jobFrontendRef, int n, IOException iOException) throws IOException {
        this.myFileWriter.outputFileWriteResult(jobFrontendRef, n, iOException);
    }

    public synchronized void outputFileFlushResult(JobFrontendRef jobFrontendRef, int n, IOException iOException) throws IOException {
        this.myFileWriter.outputFileFlushResult(jobFrontendRef, n, iOException);
    }

    public synchronized void outputFileCloseResult(JobFrontendRef jobFrontendRef, int n, IOException iOException) throws IOException {
        this.myFileWriter.outputFileCloseResult(jobFrontendRef, n, iOException);
    }

    public synchronized void inputFileOpenResult(JobFrontendRef jobFrontendRef, int n, int n2, IOException iOException) throws IOException {
        this.myFileReader.inputFileOpenResult(jobFrontendRef, n, n2, iOException);
    }

    public synchronized void inputFileReadResult(JobFrontendRef jobFrontendRef, int n, byte[] byArray, int n2, IOException iOException) throws IOException {
        this.myFileReader.inputFileReadResult(jobFrontendRef, n, n2, iOException);
    }

    public synchronized void inputFileSkipResult(JobFrontendRef jobFrontendRef, int n, long l, IOException iOException) throws IOException {
        this.myFileReader.inputFileSkipResult(jobFrontendRef, n, l, iOException);
    }

    public synchronized void inputFileCloseResult(JobFrontendRef jobFrontendRef, int n, IOException iOException) throws IOException {
        this.myFileReader.inputFileCloseResult(jobFrontendRef, n, iOException);
    }

    public synchronized void close() {
    }

    public String getUserName() {
        return this.username;
    }

    public int getJobNumber() {
        return this.jobnum;
    }

    public int getK() {
        return this.K;
    }

    public int getRank() {
        return this.rank;
    }

    public String getBackendHost() {
        return this.backendHost;
    }

    public boolean hasFrontendCommunicator() {
        return this.hasFrontendComm;
    }

    public ClassLoader getClassLoader() {
        return this.myClassLoader;
    }

    public BackendFileWriter getFileWriter() {
        return this.myFileWriter;
    }

    public BackendFileReader getFileReader() {
        return this.myFileReader;
    }

    public synchronized void waitForCommence() {
        while (!this.commence) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public ChannelGroup getWorldChannelGroup() {
        return this.myWorldChannelGroup;
    }

    public InetSocketAddress[] getWorldAddress() {
        return this.myWorldAddress;
    }

    public ChannelGroup getFrontendChannelGroup() {
        return this.myFrontendChannelGroup;
    }

    public InetSocketAddress[] getFrontendAddress() {
        return this.myFrontendAddress;
    }

    public Properties getProperties() {
        return this.myProperties;
    }

    public String getMainClassName() {
        return this.myMainClassName;
    }

    public String[] getArgs() {
        return this.myArgs;
    }

    public void setComment(String string) {
        try {
            this.myJobFrontend.reportComment(this, this.rank, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static JobBackend getJobBackend() {
        return theJobBackend;
    }

    private synchronized void frontendRenewTimeout() throws IOException {
        if (this.myFrontendRenewTimer.isTriggered()) {
            this.myJobFrontend.renewLease(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void frontendExpireTimeout() throws IOException {
        boolean bl = false;
        JobBackend jobBackend = this;
        synchronized (jobBackend) {
            if (this.myFrontendExpireTimer.isTriggered()) {
                this.reportRunFinished();
                if (this.myState == State.RUNNING) {
                    this.myState = State.TERMINATE_NO_REPORT;
                    bl = true;
                }
            }
        }
        this.myJobLauncherLog.println("Job frontend lease expired");
        if (bl) {
            System.exit(1);
        }
    }

    private void terminateCancelJob(Throwable throwable) {
        this.continueRun = false;
        if (this.myState == State.RUNNING) {
            this.myState = State.TERMINATE_CANCEL_JOB;
            this.myCancelMessage = throwable.getClass().getName();
            String string = throwable.getMessage();
            if (string != null) {
                this.myCancelMessage = this.myCancelMessage + ": " + string;
            }
        }
    }

    private void terminateNoReport() {
        this.continueRun = false;
        if (this.myState == State.RUNNING) {
            this.myState = State.TERMINATE_NO_REPORT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        JobBackend jobBackend = this;
        synchronized (jobBackend) {
            if (this.myJobFrontend != null) {
                try {
                    switch (this.myState) {
                        case RUNNING: {
                            this.myJobFrontend.backendFinished(this);
                            break;
                        }
                        case TERMINATE_CANCEL_JOB: {
                            this.myJobFrontend.cancelJob(this, this.myCancelMessage);
                            break;
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.myState = State.TERMINATING;
        }
        this.waitForRunFinished();
        jobBackend = this;
        synchronized (jobBackend) {
            this.myFrontendRenewTimer.stop();
            this.myFrontendExpireTimer.stop();
        }
    }

    private void waitForRunFinished() {
        while (true) {
            try {
                this.runFinished.await();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void reportRunFinished() {
        this.runFinished.countDown();
    }

    private synchronized void dump() {
        int n;
        System.out.println("********************************");
        System.out.println("username = " + this.username);
        System.out.println("jobnum = " + this.jobnum);
        System.out.println("K = " + this.K);
        System.out.println("rank = " + this.rank);
        System.out.println("hasFrontendComm = " + this.hasFrontendComm);
        for (n = 0; n <= this.K; ++n) {
            System.out.println("myMiddlewareAddress[" + n + "] = " + this.myMiddlewareAddress[n]);
        }
        for (n = 0; n < this.K; ++n) {
            System.out.println("myWorldAddress[" + n + "] = " + this.myWorldAddress[n]);
        }
        if (this.hasFrontendComm) {
            for (n = 0; n <= this.K; ++n) {
                System.out.println("myFrontendAddress[" + n + "] = " + this.myFrontendAddress[n]);
            }
        }
        this.myProperties.list(System.out);
        System.out.println("myMainClassName = " + this.myMainClassName);
        for (n = 0; n < this.myArgs.length; ++n) {
            System.out.println("myArgs[" + n + "] = \"" + this.myArgs[n] + "\"");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        Object object;
        try {
            if (stringArray.length != 8) {
                JobBackend.usage();
            }
            object = stringArray[0];
            int n = Integer.parseInt(stringArray[1]);
            int n2 = Integer.parseInt(stringArray[2]);
            int n3 = Integer.parseInt(stringArray[3]);
            boolean bl = Boolean.parseBoolean(stringArray[4]);
            string = stringArray[5];
            int n4 = Integer.parseInt(stringArray[6]);
            String string2 = stringArray[7];
            theJobBackend = new JobBackend((String)object, n, n2, n3, bl, string, n4, string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
        Thread.currentThread().setContextClassLoader(theJobBackend.getClassLoader());
        object = new Thread(theJobBackend);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
        theJobBackend.waitForCommence();
        Properties properties = System.getProperties();
        Properties properties2 = theJobBackend.getProperties();
        for (Map.Entry<Object, Object> entry : properties2.entrySet()) {
            string = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (properties.getProperty(string) != null) continue;
            properties.setProperty(string, string3);
        }
        System.setProperty("java.awt.headless", "true");
        Class<?> clazz = Class.forName(theJobBackend.getMainClassName(), true, theJobBackend.getClassLoader());
        Method method = clazz.getMethod("main", String[].class);
        method.invoke(null, new Object[]{theJobBackend.getArgs()});
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.pj.cluster.JobBackend <username> <jobnum> <K> <rank> <hasFrontendComm> <frontendHost> <frontendPort> <backendHost>");
        System.exit(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        RUNNING,
        TERMINATE_CANCEL_JOB,
        TERMINATE_NO_REPORT,
        TERMINATING;

    }
}

