/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.io.Files;
import edu.rit.mri.PixelAnalysis;
import edu.rit.mri.PixelSignal;
import edu.rit.mri.PixelTissues;
import edu.rit.mri.SignalDataSetReader;
import edu.rit.mri.SpinSignal;
import edu.rit.mri.TissuesDataSetWriter;
import edu.rit.numeric.ArraySeries;
import edu.rit.numeric.Series;
import edu.rit.pj.Comm;
import java.io.File;
import java.util.ArrayList;

public class SpinRelaxometrySeq {
    private SpinRelaxometrySeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        if (stringArray.length < 4) {
            SpinRelaxometrySeq.usage();
        }
        double d = Double.parseDouble(stringArray[0]);
        double d2 = Double.parseDouble(stringArray[1]);
        int n = Integer.parseInt(stringArray[2]);
        String[] stringArray2 = new String[stringArray.length - 3];
        System.arraycopy(stringArray, 3, stringArray2, 0, stringArray.length - 3);
        double[] dArray = new double[n + 1];
        double d3 = Math.log(d);
        double d4 = Math.log(d2);
        double d5 = (d4 - d3) / (double)n;
        for (int i = 0; i <= n; ++i) {
            dArray[i] = Math.exp(d3 + (double)i * d5);
        }
        ArraySeries arraySeries = new ArraySeries(dArray);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        for (int i = 0; i < stringArray2.length; ++i) {
            int n2;
            File file = new File(stringArray2[i]);
            File file2 = new File(Files.fileNamePrepend(stringArray2[i], "tissues_"));
            SignalDataSetReader signalDataSetReader = new SignalDataSetReader(file);
            int n3 = signalDataSetReader.getHeight();
            int n4 = signalDataSetReader.getWidth();
            TissuesDataSetWriter tissuesDataSetWriter = new TissuesDataSetWriter(file2, n3, n4);
            Series series = signalDataSetReader.getTimeSeries();
            int n5 = series.length();
            double[][] dArray2 = new double[n5][n + 1];
            for (n2 = 0; n2 < n5; ++n2) {
                double[] dArray3 = dArray2[n2];
                double d6 = series.x(n2);
                for (int j = 0; j <= n; ++j) {
                    dArray3[j] = SpinSignal.S(dArray[j], d6);
                }
            }
            n2 = signalDataSetReader.getPixelCount();
            for (int j = 0; j < n2; ++j) {
                PixelSignal pixelSignal = signalDataSetReader.getPixelSignal(j);
                if (pixelSignal == null) continue;
                PixelAnalysis.analyze(series, pixelSignal.S_measured(), arraySeries, dArray2, arrayList, arrayList2);
                tissuesDataSetWriter.addPixelTissues(new PixelTissues(i, j, arrayList, arrayList2));
            }
            signalDataSetReader.close();
            tissuesDataSetWriter.close();
        }
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.mri.SpinRelaxometrySeq <R1_lower> <R1_upper> <N> <signalfile> [<signalfile> ...]");
        System.err.println("<R1_lower> = Lower R1 spin-lattice relaxation rate (1/sec)");
        System.err.println("<R1_upper> = Upper R1 spin-lattice relaxation rate (1/sec)");
        System.err.println("<N> = Number of R1 intervals");
        System.err.println("<signalfile> = Input spin signal data set file");
        System.exit(1);
    }
}

