/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.mri.PixelTissues;
import edu.rit.mri.TissuesDataSetReader;
import edu.rit.numeric.plot.Plot;
import java.io.File;
import java.text.DecimalFormat;

public class R1Histogram {
    static final DecimalFormat FMT1 = new DecimalFormat("0.0");
    static final DecimalFormat FMT2 = new DecimalFormat("0.0E0");

    private R1Histogram() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 4) {
            R1Histogram.usage();
        }
        File file = new File(stringArray[0]);
        double d = Double.parseDouble(stringArray[1]);
        double d2 = Double.parseDouble(stringArray[2]);
        int n = Integer.parseInt(stringArray[3]);
        double d3 = (d2 - d) / (double)n;
        double[] dArray = new double[n + 1];
        double[] dArray2 = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            dArray[i] = d + (double)i * d3;
        }
        TissuesDataSetReader tissuesDataSetReader = new TissuesDataSetReader(file);
        int n2 = tissuesDataSetReader.getPixelCount();
        for (int i = 0; i < n2; ++i) {
            PixelTissues pixelTissues = tissuesDataSetReader.getPixelTissues(i);
            if (pixelTissues == null) continue;
            int n3 = pixelTissues.numTissues();
            for (int j = 0; j < n3; ++j) {
                double d4 = pixelTissues.R1(j);
                int n4 = (int)Math.floor((d4 - d) / d3);
                if (0 > n4 || n4 > n) continue;
                int n5 = n4;
                dArray2[n5] = dArray2[n5] + 1.0;
            }
        }
        Plot plot = new Plot();
        plot.plotTitle("<I>R</I><SUB>1</SUB> Histogram").leftMargin(54.0).xAxisLength(800.0).xAxisStart(d).xAxisEnd(d2).xAxisMajorDivisions(20).xAxisTickFormat(FMT2).xAxisTitle("Spin-lattice relaxation rate, <I>R</I><SUB>1</SUB> (sec<SUP>\u20121</SUP>)").yAxisLength(400.0).yAxisMajorDivisions(10).yAxisTickFormat(FMT2).yAxisTitle("Count").yAxisTitleOffset(42.0).xySeries(dArray, dArray2);
        plot.getFrame().setVisible(true);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.mri.R1Histogram <tissuesfile> <R1_lower> <R1_upper> <N>");
        System.err.println("<tissuesfile> = Tissues data set file");
        System.err.println("<R1_lower> = Lower R1 spin-lattice relaxation rate (1/sec)");
        System.err.println("<R1_upper> = Upper R1 spin-lattice relaxation rate (1/sec)");
        System.err.println("<N> = Number of intervals");
        System.exit(1);
    }
}

