/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.mri.SpinSignalDifference;
import edu.rit.numeric.NonLinearLeastSquares;
import edu.rit.numeric.NonNegativeLeastSquares;
import edu.rit.numeric.Series;
import edu.rit.numeric.TooManyIterationsException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PixelAnalysis {
    private PixelAnalysis() {
    }

    public static void analyze(Series series, Series series2, Series series3, double[][] dArray, List<Double> list, List<Double> list2) {
        int n;
        int n2 = series.length();
        int n3 = series3.length();
        NonNegativeLeastSquares nonNegativeLeastSquares = new NonNegativeLeastSquares(n2, n3);
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(dArray[i], 0, nonNegativeLeastSquares.a[i], 0, n3);
            nonNegativeLeastSquares.b[i] = series2.x(i);
        }
        nonNegativeLeastSquares.solve();
        double[] dArray2 = nonNegativeLeastSquares.x;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        for (n = 0; n < n3; ++n) {
            double d = dArray2[n];
            double d2 = n == 0 ? 0.0 : dArray2[n - 1];
            if (!(d > d2)) continue;
            double d3 = dArray2[n];
            double d4 = n == n3 - 1 ? 0.0 : dArray2[n + 1];
            if (!(d3 > d4)) continue;
            arrayList.add(dArray2[n]);
            arrayList2.add(series3.x(n));
        }
        n = 0;
        int n4 = arrayList.size();
        list.clear();
        list2.clear();
        while (n4 > 0 && n == 0) {
            int n5;
            SpinSignalDifference spinSignalDifference = new SpinSignalDifference(series, series2, n4);
            NonLinearLeastSquares nonLinearLeastSquares = new NonLinearLeastSquares(spinSignalDifference);
            for (n5 = 0; n5 < n4; ++n5) {
                nonLinearLeastSquares.x[n5 << 1] = (Double)arrayList.get(n5);
                nonLinearLeastSquares.x[(n5 << 1) + 1] = (Double)arrayList2.get(n5);
            }
            try {
                nonLinearLeastSquares.solve();
                for (n5 = 0; n5 < n4; ++n5) {
                    list.add(nonLinearLeastSquares.x[n5 << 1]);
                    list2.add(nonLinearLeastSquares.x[(n5 << 1) + 1]);
                }
                n = PixelAnalysis.checkPlausibility(series2, list, list2) ? 1 : 0;
            }
            catch (TooManyIterationsException tooManyIterationsException) {
                n = 0;
            }
            if (n != 0) continue;
            double d = Double.MAX_VALUE;
            int n6 = 0;
            for (int i = 0; i < n4; ++i) {
                if (!((Double)arrayList.get(i) < d)) continue;
                d = (Double)arrayList.get(i);
                n6 = i;
            }
            arrayList.remove(n6);
            arrayList2.remove(n6);
            n4 = arrayList.size();
            list.clear();
            list2.clear();
        }
    }

    private static boolean checkPlausibility(Series series, List<Double> list, List<Double> list2) {
        double d;
        int n;
        int n2 = series.length();
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            if (list.get(n) < 0.0) {
                return false;
            }
            if (!(list2.get(n) < 0.0)) continue;
            return false;
        }
        for (n = 0; n < n3 - 1; ++n) {
            double d2 = list2.get(n);
            for (int i = n + 1; i < n3; ++i) {
                double d3 = list2.get(i);
                double d4 = 2.0 * Math.abs(d2 - d3) / Math.abs(d2 + d3);
                if (!(d4 <= 0.001)) continue;
                return false;
            }
        }
        double d5 = 0.0;
        for (int i = 0; i < n3; ++i) {
            d5 += list.get(i).doubleValue();
        }
        double d6 = 0.0;
        int n4 = 0;
        for (int i = n2 - 1; i >= 0 && n4 < 7; ++n4, --i) {
            d6 += series.x(i);
        }
        return !((d = Math.abs(d5 - (d6 /= (double)n4)) / Math.abs(d6)) >= 0.2);
    }
}

