/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.Unsigned16BitIntegerBuf;
import edu.rit.mp.buf.Unsigned16BitIntegerArrayReductionBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class Unsigned16BitIntegerArrayBuf
extends Unsigned16BitIntegerBuf {
    int[] myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public Unsigned16BitIntegerArrayBuf(int[] nArray, Range range) {
        super(range.length());
        this.myArray = nArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public int get(int n) {
        return this.myArray[this.myArrayOffset + n * this.myStride];
    }

    public void put(int n, int n2) {
        this.myArray[this.myArrayOffset + n * this.myStride] = n2;
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof Unsigned16BitIntegerArrayBuf) {
                Unsigned16BitIntegerArrayBuf unsigned16BitIntegerArrayBuf = (Unsigned16BitIntegerArrayBuf)buf;
                Arrays.copy(unsigned16BitIntegerArrayBuf.myArray, unsigned16BitIntegerArrayBuf.myRange, this.myArray, this.myRange);
            } else {
                Unsigned16BitIntegerBuf.defaultCopy((Unsigned16BitIntegerBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        return new Unsigned16BitIntegerArrayReductionBuf(this.myArray, this.myRange, (IntegerOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 2) {
            byteBuffer.putShort((short)this.myArray[n3]);
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 2) {
            this.myArray[n4] = byteBuffer.getShort() & 0xFFFF;
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

