/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.FloatBuf;
import edu.rit.mp.buf.FloatMatrixBuf;
import edu.rit.mp.buf.FloatMatrixBuf_1;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

class FloatMatrixReductionBuf_1
extends FloatMatrixBuf_1 {
    FloatOp myOp;

    public FloatMatrixReductionBuf_1(float[][] fArray, Range range, Range range2, FloatOp floatOp) {
        super(fArray, range, range2);
        if (floatOp == null) {
            throw new NullPointerException("FloatMatrixReductionBuf_1(): op is null");
        }
        this.myOp = floatOp;
    }

    public void put(int n, float f) {
        int n2 = n / this.myColCount + this.myLowerRow;
        int n3 = n % this.myColCount + this.myLowerCol;
        this.myMatrix[n2][n3] = this.myOp.op(this.myMatrix[n2][n3], f);
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof FloatMatrixBuf) {
                FloatMatrixBuf floatMatrixBuf = (FloatMatrixBuf)buf;
                ReduceArrays.reduce(floatMatrixBuf.myMatrix, floatMatrixBuf.myRowRange, floatMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                FloatBuf.defaultCopy((FloatBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        n2 = Math.min(n2, floatBuffer.remaining());
        int n3 = 0;
        int n4 = this.i2r(n);
        int n5 = n4 + this.myLowerRow;
        int n6 = this.i2c(n);
        int n7 = n6 + this.myLowerCol;
        int n8 = Math.min(this.myColCount - n6, n2);
        while (n4 < this.myRowCount && n8 > 0) {
            float[] fArray = this.myMatrix[n5];
            for (n6 = 0; n6 < n8; ++n6) {
                fArray[n7] = this.myOp.op(fArray[n7], floatBuffer.get());
                ++n7;
            }
            n3 += n8;
            ++n4;
            ++n5;
            n7 = this.myLowerCol;
            n8 = Math.min(this.myColCount, n2 -= n8);
        }
        byteBuffer.position(byteBuffer.position() + 4 * n3);
        return n3;
    }
}

