/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.DrawingItem;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.Size;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class Group
extends DrawingItem
implements Externalizable {
    public static final double NORMAL_X_SCALE = 1.0;
    public static final double NORMAL_Y_SCALE = 1.0;
    public static final double NORMAL_X_SHEAR = 0.0;
    public static final double NORMAL_Y_SHEAR = 0.0;
    public static final double NORMAL_ROTATION_ANGLE = 0.0;
    private static final long serialVersionUID = -2445041343028527776L;
    static double theDefaultXScale = 1.0;
    static double theDefaultYScale = 1.0;
    static double theDefaultXShear = 0.0;
    static double theDefaultYShear = 0.0;
    static double theDefaultRotationAngle = 0.0;
    ArrayList<DrawingItem> myItemList;
    double x;
    double y;
    double xFactor;
    double yFactor;
    boolean cornerIsOriginal;
    double myXScale = theDefaultXScale;
    double myYScale = theDefaultYScale;
    double myXShear = theDefaultXShear;
    double myYShear = theDefaultYShear;
    double myRotationAngle = theDefaultRotationAngle;
    AffineTransform myTransform;
    Point myOriginalNw;
    Size myOriginalSize;
    Point myTransformedNw;
    Size myTransformedSize;

    public Group() {
        this.myItemList = new ArrayList();
    }

    public Group(Group group) {
        super(group);
        this.myItemList = new ArrayList<DrawingItem>(group.myItemList);
        this.x = group.x;
        this.y = group.y;
        this.xFactor = group.xFactor;
        this.yFactor = group.yFactor;
        this.cornerIsOriginal = group.cornerIsOriginal;
        this.myXScale = group.myXScale;
        this.myYScale = group.myYScale;
        this.myXShear = group.myXShear;
        this.myYShear = group.myYShear;
        this.myRotationAngle = group.myRotationAngle;
    }

    public static double defaultXScale() {
        return theDefaultXScale;
    }

    public static void defaultXScale(double d) {
        theDefaultXScale = d;
    }

    public static double defaultYScale() {
        return theDefaultYScale;
    }

    public static void defaultYScale(double d) {
        theDefaultYScale = d;
    }

    public static double defaultXShear() {
        return theDefaultXShear;
    }

    public static void defaultXShear(double d) {
        theDefaultXShear = d;
    }

    public static double defaultYShear() {
        return theDefaultYShear;
    }

    public static void defaultYShear(double d) {
        theDefaultYShear = d;
    }

    public static double defaultRotationAngle() {
        return theDefaultRotationAngle;
    }

    public static void defaultRotationAngle(double d) {
        theDefaultRotationAngle = d;
    }

    public double xScale() {
        return this.myXScale;
    }

    public Group xScale(double d) {
        this.myXScale = d;
        this.myTransform = null;
        this.myTransformedNw = null;
        return this;
    }

    public double yScale() {
        return this.myYScale;
    }

    public Group yScale(double d) {
        this.myYScale = d;
        this.myTransform = null;
        this.myTransformedNw = null;
        return this;
    }

    public double xShear() {
        return this.myXShear;
    }

    public Group xShear(double d) {
        this.myXShear = d;
        this.myTransform = null;
        this.myTransformedNw = null;
        return this;
    }

    public double yShear() {
        return this.myYShear;
    }

    public Group yShear(double d) {
        this.myYShear = d;
        this.myTransform = null;
        this.myTransformedNw = null;
        return this;
    }

    public double rotationAngle() {
        return this.myRotationAngle;
    }

    public Group rotationAngle(double d) {
        this.myRotationAngle = d;
        this.myTransform = null;
        this.myTransformedNw = null;
        return this;
    }

    public Group clear() {
        this.myItemList.clear();
        this.myOriginalNw = null;
        this.myTransformedNw = null;
        return this;
    }

    public Group append(DrawingItem drawingItem) {
        if (drawingItem == null) {
            throw new NullPointerException();
        }
        this.myItemList.add(drawingItem);
        this.myOriginalNw = null;
        this.myTransformedNw = null;
        return this;
    }

    public Group prepend(DrawingItem drawingItem) {
        if (drawingItem == null) {
            throw new NullPointerException();
        }
        this.myItemList.add(0, drawingItem);
        this.myOriginalNw = null;
        this.myTransformedNw = null;
        return this;
    }

    public Size size() {
        this.computeTransformedBoundingBox();
        return this.myTransformedSize;
    }

    public double width() {
        this.computeTransformedBoundingBox();
        return this.myTransformedSize.width();
    }

    public double height() {
        this.computeTransformedBoundingBox();
        return this.myTransformedSize.height();
    }

    public Point nw() {
        this.computeTransformedBoundingBox();
        return this.myTransformedNw;
    }

    public Group nw(double d, double d2) {
        this.doNw(d, d2, false);
        return this;
    }

    public Group nw(Point point) {
        this.doNw(point.x, point.y, false);
        return this;
    }

    public Group n(double d, double d2) {
        this.doN(d, d2, false);
        return this;
    }

    public Group n(Point point) {
        this.doN(point.x, point.y, false);
        return this;
    }

    public Group ne(double d, double d2) {
        this.doNe(d, d2, false);
        return this;
    }

    public Group ne(Point point) {
        this.doNe(point.x, point.y, false);
        return this;
    }

    public Group w(double d, double d2) {
        this.doW(d, d2, false);
        return this;
    }

    public Group w(Point point) {
        this.doW(point.x, point.y, false);
        return this;
    }

    public Group c(double d, double d2) {
        this.doC(d, d2, false);
        return this;
    }

    public Group c(Point point) {
        this.doC(point.x, point.y, false);
        return this;
    }

    public Group e(double d, double d2) {
        this.doE(d, d2, false);
        return this;
    }

    public Group e(Point point) {
        this.doE(point.x, point.y, false);
        return this;
    }

    public Group sw(double d, double d2) {
        this.doSw(d, d2, false);
        return this;
    }

    public Group sw(Point point) {
        this.doSw(point.x, point.y, false);
        return this;
    }

    public Group s(double d, double d2) {
        this.doS(d, d2, false);
        return this;
    }

    public Group s(Point point) {
        this.doS(point.x, point.y, false);
        return this;
    }

    public Group se(double d, double d2) {
        this.doSe(d, d2, false);
        return this;
    }

    public Group se(Point point) {
        this.doSe(point.x, point.y, false);
        return this;
    }

    public Point orig_nw() {
        this.computeTransformedBoundingBox();
        Point2D.Double double_ = new Point2D.Double(this.myOriginalNw.x, this.myOriginalNw.y);
        this.myTransform.transform(double_, double_);
        return new Point(double_.x, double_.y);
    }

    public Group orig_nw(double d, double d2) {
        this.doNw(d, d2, true);
        return this;
    }

    public Group orig_nw(Point point) {
        this.doNw(point.x, point.y, true);
        return this;
    }

    public Point orig_n() {
        this.computeTransformedBoundingBox();
        Point2D.Double double_ = new Point2D.Double(this.myOriginalNw.x + 0.5 * this.myOriginalSize.width, this.myOriginalNw.y);
        this.myTransform.transform(double_, double_);
        return new Point(double_.x, double_.y);
    }

    public Group orig_n(double d, double d2) {
        this.doN(d, d2, true);
        return this;
    }

    public Group orig_n(Point point) {
        this.doN(point.x, point.y, true);
        return this;
    }

    public Point orig_ne() {
        this.computeTransformedBoundingBox();
        Point2D.Double double_ = new Point2D.Double(this.myOriginalNw.x + this.myOriginalSize.width(), this.myOriginalNw.y);
        this.myTransform.transform(double_, double_);
        return new Point(double_.x, double_.y);
    }

    public Group orig_ne(double d, double d2) {
        this.doNe(d, d2, true);
        return this;
    }

    public Group orig_ne(Point point) {
        this.doNe(point.x, point.y, true);
        return this;
    }

    public Point orig_w() {
        this.computeTransformedBoundingBox();
        Point2D.Double double_ = new Point2D.Double(this.myOriginalNw.x, this.myOriginalNw.y + 0.5 * this.myOriginalSize.height());
        this.myTransform.transform(double_, double_);
        return new Point(double_.x, double_.y);
    }

    public Group orig_w(double d, double d2) {
        this.doW(d, d2, true);
        return this;
    }

    public Group orig_w(Point point) {
        this.doW(point.x, point.y, true);
        return this;
    }

    public Point orig_c() {
        this.computeTransformedBoundingBox();
        Point2D.Double double_ = new Point2D.Double(this.myOriginalNw.x + 0.5 * this.myOriginalSize.width(), this.myOriginalNw.y + 0.5 * this.myOriginalSize.height());
        this.myTransform.transform(double_, double_);
        return new Point(double_.x, double_.y);
    }

    public Group orig_c(double d, double d2) {
        this.doC(d, d2, true);
        return this;
    }

    public Group orig_c(Point point) {
        this.doC(point.x, point.y, true);
        return this;
    }

    public Point orig_e() {
        this.computeTransformedBoundingBox();
        Point2D.Double double_ = new Point2D.Double(this.myOriginalNw.x + this.myOriginalSize.width(), this.myOriginalNw.y + 0.5 * this.myOriginalSize.height());
        this.myTransform.transform(double_, double_);
        return new Point(double_.x, double_.y);
    }

    public Group orig_e(double d, double d2) {
        this.doE(d, d2, true);
        return this;
    }

    public Group orig_e(Point point) {
        this.doE(point.x, point.y, true);
        return this;
    }

    public Point orig_sw() {
        this.computeTransformedBoundingBox();
        Point2D.Double double_ = new Point2D.Double(this.myOriginalNw.x, this.myOriginalNw.y + this.myOriginalSize.height());
        this.myTransform.transform(double_, double_);
        return new Point(double_.x, double_.y);
    }

    public Group orig_sw(double d, double d2) {
        this.doSw(d, d2, true);
        return this;
    }

    public Group orig_sw(Point point) {
        this.doSw(point.x, point.y, true);
        return this;
    }

    public Point orig_s() {
        this.computeTransformedBoundingBox();
        Point2D.Double double_ = new Point2D.Double(this.myOriginalNw.x + 0.5 * this.myOriginalSize.width(), this.myOriginalNw.y + this.myOriginalSize.height());
        this.myTransform.transform(double_, double_);
        return new Point(double_.x, double_.y);
    }

    public Group orig_s(double d, double d2) {
        this.doS(d, d2, true);
        return this;
    }

    public Group orig_s(Point point) {
        this.doS(point.x, point.y, true);
        return this;
    }

    public Point orig_se() {
        this.computeTransformedBoundingBox();
        Point2D.Double double_ = new Point2D.Double(this.myOriginalNw.x + this.myOriginalSize.width(), this.myOriginalNw.y + this.myOriginalSize.height());
        this.myTransform.transform(double_, double_);
        return new Point(double_.x, double_.y);
    }

    public Group orig_se(double d, double d2) {
        this.doSe(d, d2, true);
        return this;
    }

    public Group orig_se(Point point) {
        this.doSe(point.x, point.y, true);
        return this;
    }

    public Point content_nw() {
        this.computeOriginalBoundingBox();
        return new Point(this.myOriginalNw.x, this.myOriginalNw.y);
    }

    public Point content_n() {
        this.computeOriginalBoundingBox();
        return new Point(this.myOriginalNw.x + 0.5 * this.myOriginalSize.width, this.myOriginalNw.y);
    }

    public Point content_ne() {
        this.computeOriginalBoundingBox();
        return new Point(this.myOriginalNw.x + this.myOriginalSize.width, this.myOriginalNw.y);
    }

    public Point content_w() {
        this.computeOriginalBoundingBox();
        return new Point(this.myOriginalNw.x, this.myOriginalNw.y + 0.5 * this.myOriginalSize.height);
    }

    public Point content_c() {
        this.computeOriginalBoundingBox();
        return new Point(this.myOriginalNw.x + 0.5 * this.myOriginalSize.width, this.myOriginalNw.y + 0.5 * this.myOriginalSize.height);
    }

    public Point content_e() {
        this.computeOriginalBoundingBox();
        return new Point(this.myOriginalNw.x + this.myOriginalSize.width, this.myOriginalNw.y + 0.5 * this.myOriginalSize.height);
    }

    public Point content_sw() {
        this.computeOriginalBoundingBox();
        return new Point(this.myOriginalNw.x, this.myOriginalNw.y + this.myOriginalSize.height);
    }

    public Point content_s() {
        this.computeOriginalBoundingBox();
        return new Point(this.myOriginalNw.x + 0.5 * this.myOriginalSize.width, this.myOriginalNw.y + this.myOriginalSize.height);
    }

    public Point content_se() {
        this.computeOriginalBoundingBox();
        return new Point(this.myOriginalNw.x + this.myOriginalSize.width, this.myOriginalNw.y + this.myOriginalSize.height);
    }

    public Group add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public Group add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public Group addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public Group addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        int n = this.myItemList.size();
        objectOutput.writeInt(n);
        for (DrawingItem drawingItem : this.myItemList) {
            objectOutput.writeObject(drawingItem);
        }
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.xFactor);
        objectOutput.writeDouble(this.yFactor);
        objectOutput.writeBoolean(this.cornerIsOriginal);
        objectOutput.writeDouble(this.myXScale);
        objectOutput.writeDouble(this.myYScale);
        objectOutput.writeDouble(this.myXShear);
        objectOutput.writeDouble(this.myYShear);
        objectOutput.writeDouble(this.myRotationAngle);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.myItemList.clear();
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            this.myItemList.add((DrawingItem)objectInput.readObject());
        }
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.xFactor = objectInput.readDouble();
        this.yFactor = objectInput.readDouble();
        this.cornerIsOriginal = objectInput.readBoolean();
        this.myXScale = objectInput.readDouble();
        this.myYScale = objectInput.readDouble();
        this.myXShear = objectInput.readDouble();
        this.myYShear = objectInput.readDouble();
        this.myRotationAngle = objectInput.readDouble();
        this.myTransform = null;
        this.myOriginalNw = null;
        this.myTransformedNw = null;
    }

    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        this.computeTransformedBoundingBox();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(this.myTransform);
        for (DrawingItem drawingItem : this.myItemList) {
            drawingItem.draw(graphics2D);
        }
        graphics2D.setTransform(affineTransform);
    }

    public Point transform(Point point) {
        this.computeTransformedBoundingBox();
        Point2D.Double double_ = new Point2D.Double(point.x, point.y);
        this.myTransform.transform(double_, double_);
        return new Point(double_.x, double_.y);
    }

    private void computeOriginalBoundingBox() {
        if (this.myOriginalNw == null) {
            double d = Double.MAX_VALUE;
            double d2 = Double.MAX_VALUE;
            double d3 = Double.MIN_VALUE;
            double d4 = Double.MIN_VALUE;
            for (DrawingItem drawingItem : this.myItemList) {
                Point point = drawingItem.nw();
                d = Math.min(d, point.x);
                d2 = Math.min(d2, point.y);
                point = drawingItem.se();
                d3 = Math.max(d3, point.x);
                d4 = Math.max(d4, point.y);
            }
            this.myOriginalNw = new Point(d, d2);
            this.myOriginalSize = new Size(d3 - d, d4 - d2);
        }
    }

    private void computeTransformedBoundingBox() {
        if (this.myTransformedNw == null) {
            Point2D.Double double_ = new Point2D.Double();
            AffineTransform affineTransform = new AffineTransform();
            AffineTransform affineTransform2 = new AffineTransform();
            this.computeOriginalBoundingBox();
            affineTransform.shear(this.myXShear, this.myYShear);
            affineTransform.scale(this.myXScale, this.myYScale);
            double_.x = this.myOriginalNw.x() + this.myOriginalSize.width() / 2.0;
            double_.y = this.myOriginalNw.y() + this.myOriginalSize.height() / 2.0;
            affineTransform.transform(double_, double_);
            affineTransform2.setToRotation(this.myRotationAngle, double_.x, double_.y);
            affineTransform.preConcatenate(affineTransform2);
            double d = Double.MAX_VALUE;
            double d2 = Double.MAX_VALUE;
            double d3 = Double.MIN_VALUE;
            double d4 = Double.MIN_VALUE;
            for (DrawingItem drawingItem : this.myItemList) {
                Point point = drawingItem.nw();
                double_.x = point.x;
                double_.y = point.y;
                affineTransform.transform(double_, double_);
                d = Math.min(d, double_.x);
                d2 = Math.min(d2, double_.y);
                d3 = Math.max(d3, double_.x);
                d4 = Math.max(d4, double_.y);
                point = drawingItem.ne();
                double_.x = point.x;
                double_.y = point.y;
                affineTransform.transform(double_, double_);
                d = Math.min(d, double_.x);
                d2 = Math.min(d2, double_.y);
                d3 = Math.max(d3, double_.x);
                d4 = Math.max(d4, double_.y);
                point = drawingItem.sw();
                double_.x = point.x;
                double_.y = point.y;
                affineTransform.transform(double_, double_);
                d = Math.min(d, double_.x);
                d2 = Math.min(d2, double_.y);
                d3 = Math.max(d3, double_.x);
                d4 = Math.max(d4, double_.y);
                point = drawingItem.se();
                double_.x = point.x;
                double_.y = point.y;
                affineTransform.transform(double_, double_);
                d = Math.min(d, double_.x);
                d2 = Math.min(d2, double_.y);
                d3 = Math.max(d3, double_.x);
                d4 = Math.max(d4, double_.y);
            }
            this.myTransformedSize = new Size(d3 - d, d4 - d2);
            if (this.cornerIsOriginal) {
                double_.x = this.myOriginalNw.x - this.xFactor * this.myOriginalSize.width();
                double_.y = this.myOriginalNw.y - this.yFactor * this.myOriginalSize.height();
                affineTransform.transform(double_, double_);
                affineTransform2.setToTranslation(this.x - double_.x, this.y - double_.y);
                affineTransform.preConcatenate(affineTransform2);
                this.myTransformedNw = new Point(d + this.x - double_.x, d2 + this.y - double_.y);
            } else {
                this.myTransformedNw = new Point(this.x + this.xFactor * this.myTransformedSize.width(), this.y + this.yFactor * this.myTransformedSize.height());
                affineTransform2.setToTranslation(this.myTransformedNw.x - d, this.myTransformedNw.y - d2);
                affineTransform.preConcatenate(affineTransform2);
            }
            this.myTransform = affineTransform;
        }
    }

    void doNw(double d, double d2, boolean bl) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = 0.0;
        this.cornerIsOriginal = bl;
        this.myOriginalNw = null;
        this.myTransformedNw = null;
    }

    void doN(double d, double d2, boolean bl) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = 0.0;
        this.cornerIsOriginal = bl;
        this.myOriginalNw = null;
        this.myTransformedNw = null;
    }

    void doNe(double d, double d2, boolean bl) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = 0.0;
        this.cornerIsOriginal = bl;
        this.myOriginalNw = null;
        this.myTransformedNw = null;
    }

    void doW(double d, double d2, boolean bl) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = -0.5;
        this.cornerIsOriginal = bl;
        this.myOriginalNw = null;
        this.myTransformedNw = null;
    }

    void doC(double d, double d2, boolean bl) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = -0.5;
        this.cornerIsOriginal = bl;
        this.myOriginalNw = null;
        this.myTransformedNw = null;
    }

    void doE(double d, double d2, boolean bl) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = -0.5;
        this.cornerIsOriginal = bl;
        this.myOriginalNw = null;
        this.myTransformedNw = null;
    }

    void doSw(double d, double d2, boolean bl) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = -1.0;
        this.cornerIsOriginal = bl;
        this.myOriginalNw = null;
        this.myTransformedNw = null;
    }

    void doS(double d, double d2, boolean bl) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = -1.0;
        this.cornerIsOriginal = bl;
        this.myOriginalNw = null;
        this.myTransformedNw = null;
    }

    void doSe(double d, double d2, boolean bl) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = -1.0;
        this.cornerIsOriginal = bl;
        this.myOriginalNw = null;
        this.myTransformedNw = null;
    }
}

