/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.seq;

import edu.rit.compbio.seq.Alignment;
import edu.rit.compbio.seq.AlignmentPrinter;
import edu.rit.compbio.seq.DefaultAlignmentStats;
import edu.rit.compbio.seq.ProteinDatabase;
import edu.rit.compbio.seq.ProteinLocalAlignment;
import edu.rit.compbio.seq.ProteinLocalAlignmentSeq;
import edu.rit.compbio.seq.ProteinSequence;
import edu.rit.pj.Comm;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class FindProteinSeq {
    static File queryfile;
    static File databasefile;
    static File indexfile;
    static double expect;

    private FindProteinSeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        long l;
        long l2 = System.currentTimeMillis();
        Comm.init(stringArray);
        if (3 > stringArray.length || stringArray.length > 4) {
            FindProteinSeq.usage();
        }
        queryfile = new File(stringArray[0]);
        databasefile = new File(stringArray[1]);
        indexfile = new File(stringArray[2]);
        expect = 10.0;
        if (stringArray.length == 4) {
            expect = Double.parseDouble(stringArray[3]);
        }
        ProteinSequence proteinSequence = new ProteinSequence(queryfile);
        ProteinDatabase proteinDatabase = new ProteinDatabase(databasefile, indexfile);
        DefaultAlignmentStats defaultAlignmentStats = new DefaultAlignmentStats(proteinDatabase.getDatabaseLength());
        ArrayList<Alignment> arrayList = new ArrayList<Alignment>();
        ProteinLocalAlignmentSeq proteinLocalAlignmentSeq = new ProteinLocalAlignmentSeq();
        proteinLocalAlignmentSeq.setQuerySequence(proteinSequence, 0L);
        long l3 = System.currentTimeMillis();
        for (l = 0L; l < proteinDatabase.getProteinCount(); ++l) {
            object = proteinDatabase.getProteinSequence(l);
            proteinLocalAlignmentSeq.setSubjectSequence((ProteinSequence)object, l);
            Iterator iterator = ((ProteinLocalAlignment)proteinLocalAlignmentSeq).align();
            if (!(defaultAlignmentStats.eValue((Alignment)((Object)iterator)) <= expect)) continue;
            arrayList.add((Alignment)((Object)iterator));
        }
        l = System.currentTimeMillis();
        Collections.sort(arrayList);
        object = new AlignmentPrinter(System.out, defaultAlignmentStats);
        System.out.println("Query Description:");
        System.out.println(proteinSequence.description());
        System.out.println("Length = " + proteinSequence.length());
        System.out.println();
        System.out.println("                                                                Bit  E-");
        System.out.println("Subject Description                                           Score  Value");
        for (Alignment alignment : arrayList) {
            ((AlignmentPrinter)object).printSummary(alignment, proteinDatabase.getProteinSequence(alignment.getSubjectId()));
        }
        System.out.println();
        for (Alignment alignment : arrayList) {
            ((AlignmentPrinter)object).printDetails(alignment, proteinSequence, proteinDatabase.getProteinSequence(alignment.getSubjectId()));
        }
        System.out.println("Query file: " + queryfile);
        System.out.println("Database file: " + databasefile);
        System.out.println("Database index file: " + indexfile);
        System.out.println("Number of sequences: " + proteinDatabase.getProteinCount());
        System.out.println("Number of matches: " + arrayList.size());
        System.out.println("Query length: " + proteinSequence.length());
        System.out.println("Database length: " + proteinDatabase.getDatabaseLength());
        defaultAlignmentStats.print(System.out);
        System.out.println();
        proteinDatabase.close();
        long l4 = System.currentTimeMillis();
        System.out.println(l3 - l2 + " msec pre");
        System.out.println(l - l3 + " msec calc");
        System.out.println(l4 - l + " msec post");
        System.out.println(l4 - l2 + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.compbio.seq.FindProteinSeq <queryfile> <databasefile> <indexfile> [<expect>]");
        System.err.println("<queryfile> = Query sequence file");
        System.err.println("<databasefile> = Protein sequence database file");
        System.err.println("<indexfile> = Protein sequence index file");
        System.err.println("<expect> = E-value threshold (default: 10)");
        System.exit(1);
    }
}

