/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl.test;

import edu.rit.compbio.phyl.DnaSequence;
import edu.rit.compbio.phyl.DnaSequenceTree;

public class Test03 {
    static int N;
    static DnaSequenceTree[] treestack;
    static DnaSequence[] seqstack;
    private static final char[] v2c;

    private Test03() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length != 1) {
            Test03.usage();
        }
        N = Integer.parseInt(stringArray[0]);
        treestack = new DnaSequenceTree[N];
        for (n = 0; n < N; ++n) {
            Test03.treestack[n] = new DnaSequenceTree(2 * n + 1);
        }
        seqstack = new DnaSequence[N];
        for (n = 0; n < N; ++n) {
            Test03.seqstack[n] = new DnaSequence(0, 0, Test03.nameForLevel(n));
        }
        treestack[0].add(0, seqstack[0]);
        Test03.generateTrees(0);
    }

    private static void generateTrees(int n) {
        DnaSequenceTree dnaSequenceTree = treestack[n];
        if (n == N - 1) {
            System.out.println(dnaSequenceTree);
        } else {
            DnaSequenceTree dnaSequenceTree2 = treestack[n + 1];
            int n2 = dnaSequenceTree.length();
            for (int i = 0; i < n2; ++i) {
                dnaSequenceTree2.copy(dnaSequenceTree);
                dnaSequenceTree2.add(i, seqstack[n + 1]);
                Test03.generateTrees(n + 1);
            }
        }
    }

    private static String nameForLevel(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n + 1; i > 0; i /= 27) {
            stringBuilder.insert(0, v2c[i % 27]);
        }
        return stringBuilder.toString();
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.compbio.phyl.test.Test03 <N>");
        System.err.println("<N> = Number of tip nodes");
        System.exit(1);
    }

    static {
        v2c = new char[]{' ', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    }
}

