/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.monte;

import edu.rit.crypto.blockcipher.AES256Cipher;
import edu.rit.mp.DoubleBuf;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.DoubleItemBuf;
import edu.rit.mp.buf.LongItemBuf;
import edu.rit.numeric.Statistics;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.DoubleOp;
import edu.rit.pj.reduction.LongOp;
import edu.rit.util.Hex;
import edu.rit.util.LongRange;
import edu.rit.util.Range;
import java.util.Arrays;

public class AesTestClu {
    static Comm world;
    static int size;
    static int rank;
    static byte[] key;
    static long N;
    static AES256Cipher cipher;
    static byte[] plaintext;
    static byte[] ciphertext;
    static double[] sendData;
    static int[] sendLength;
    static int sendN;
    static int[] recvLength;
    static int recvN;
    static Range[] sendRanges;
    static Range[] recvRanges;
    static double[] data;
    static long lowerN;
    static double TWO_SUP_64;

    private AesTestClu() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 2) {
            AesTestClu.usage();
        }
        Hex.toByteArray(stringArray[0], key);
        N = Long.parseLong(stringArray[1]);
        cipher = new AES256Cipher(key);
        TWO_SUP_64 = 2.0;
        TWO_SUP_64 *= TWO_SUP_64;
        TWO_SUP_64 *= TWO_SUP_64;
        TWO_SUP_64 *= TWO_SUP_64;
        TWO_SUP_64 *= TWO_SUP_64;
        TWO_SUP_64 *= TWO_SUP_64;
        TWO_SUP_64 *= TWO_SUP_64;
        LongRange longRange = new LongRange(0L, N - 1L).subrange(size, rank);
        long l2 = longRange.lb();
        long l3 = longRange.length();
        sendData = new double[(int)l3];
        for (long i = 0L; i < l3; ++i) {
            AesTestClu.longToBytes(l2 + i, plaintext, 8);
            cipher.encrypt(plaintext, ciphertext);
            AesTestClu.sendData[(int)i] = AesTestClu.bytesToDouble(ciphertext, 0);
        }
        if (size > 1) {
            int n;
            Arrays.sort(sendData);
            sendLength = new int[size];
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < size; ++n) {
                double d = (double)(n + 1) / (double)size;
                while ((long)n3 < l3 && sendData[n3] < d) {
                    ++n3;
                }
                AesTestClu.sendLength[n] = n3 - n2;
                n2 = n3;
            }
            recvLength = new int[size];
            world.allToAll(IntegerBuf.sliceBuffers(sendLength, new Range(0, size - 1).subranges(size)), IntegerBuf.sliceBuffers(recvLength, new Range(0, size - 1).subranges(size)));
            sendRanges = new Range[size];
            sendN = 0;
            recvRanges = new Range[size];
            recvN = 0;
            for (n = 0; n < size; ++n) {
                AesTestClu.sendRanges[n] = new Range(sendN, sendN + sendLength[n] - 1);
                sendN += sendLength[n];
                AesTestClu.recvRanges[n] = new Range(recvN, recvN + recvLength[n] - 1);
                recvN += recvLength[n];
            }
            data = new double[recvN];
            world.allToAll(DoubleBuf.sliceBuffers(sendData, sendRanges), DoubleBuf.sliceBuffers(data, recvRanges));
            sendData = null;
            LongItemBuf longItemBuf = LongBuf.buffer(recvN);
            world.exclusiveScan(longItemBuf, LongOp.SUM, 0L);
            lowerN = longItemBuf.item;
        } else {
            data = sendData;
            sendData = null;
            recvN = (int)l3;
            lowerN = 0L;
        }
        Arrays.sort(data);
        double d = N;
        double d2 = 0.0;
        double d3 = (double)lowerN / d;
        for (int i = 0; i < recvN; ++i) {
            double d4 = (double)(lowerN + (long)i + 1L) / d;
            double d5 = data[i];
            d2 = Math.max(d2, Math.abs(d5 - d3));
            d2 = Math.max(d2, Math.abs(d5 - d4));
            d3 = d4;
        }
        DoubleItemBuf doubleItemBuf = DoubleBuf.buffer(d2);
        world.reduce(0, doubleItemBuf, DoubleOp.MAXIMUM);
        d2 = doubleItemBuf.item;
        double d6 = Statistics.ksPvalue(N, d2);
        l += System.currentTimeMillis();
        if (rank == 0) {
            System.out.println("N = " + N);
            System.out.println("D = " + d2);
            System.out.println("P = " + d6);
        }
        System.out.println(l + " msec " + rank);
    }

    private static void longToBytes(long l, byte[] byArray, int n) {
        for (int i = 7; i >= 0; --i) {
            byArray[n + i] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
    }

    private static double bytesToDouble(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = l << 8 | (long)(byArray[n + i] & 0xFF);
        }
        return (double)l / TWO_SUP_64 + 0.5;
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> edu.rit.clu.monte.AesTestClu <key> <N>");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<key> = Block cipher key");
        System.err.println("<N> = Number of blocks");
        System.exit(1);
    }

    static {
        key = new byte[32];
        plaintext = new byte[16];
        ciphertext = new byte[16];
    }
}

