/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.heat;

import edu.rit.image.GrayImageRow;
import edu.rit.image.PJGGrayImage;
import edu.rit.image.PJGImage;
import edu.rit.pj.Comm;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class HotSpotGray {
    private static final double MIN_TEMP = 0.0;
    private static final double MAX_TEMP = 100.0;
    private static final double DELTA_TEMP = 100.0;
    private static final double MIN_GRAY = 0.0;
    private static final double MAX_GRAY = 1.0;
    private static final double DELTA_GRAY = 1.0;
    private static final double EPS = 0.001;
    static File imagefile;
    static int H;
    static int W;
    static double[][] h;
    static boolean[][] hotspot;
    static double EPS_initialTotalAbsXi;
    static double totalAbsXi;
    static int MAXITER;
    static double rho_s_sqr;
    static double omega_over_4;
    static int iterations;

    private HotSpotGray() {
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        int n;
        Object[] objectArray;
        int n2;
        int n3;
        Comm.init(stringArray);
        long l = System.currentTimeMillis();
        if (stringArray.length < 8 || stringArray.length % 5 != 3) {
            HotSpotGray.usage();
        }
        imagefile = new File(stringArray[0]);
        H = Integer.parseInt(stringArray[1]);
        W = Integer.parseInt(stringArray[2]);
        if (H < 1) {
            HotSpotGray.usage();
        }
        if (W < 1) {
            HotSpotGray.usage();
        }
        h = new double[H + 2][W + 2];
        hotspot = new boolean[H + 2][W + 2];
        int n4 = (stringArray.length - 3) / 5;
        for (int i = 0; i < n4; ++i) {
            int n5 = Integer.parseInt(stringArray[3 + 5 * i]);
            n3 = Integer.parseInt(stringArray[4 + 5 * i]);
            int n6 = Integer.parseInt(stringArray[5 + 5 * i]);
            int n7 = Integer.parseInt(stringArray[6 + 5 * i]);
            double d = Double.parseDouble(stringArray[7 + 5 * i]);
            if (1 > n5 || n5 > W) {
                HotSpotGray.usage();
            }
            if (1 > n3 || n3 > H) {
                HotSpotGray.usage();
            }
            if (1 > n6 || n6 > W) {
                HotSpotGray.usage();
            }
            if (1 > n7 || n7 > H) {
                HotSpotGray.usage();
            }
            if (0.0 > d || d > 100.0) {
                HotSpotGray.usage();
            }
            for (n2 = n5; n2 <= n6; ++n2) {
                objectArray = h[n2];
                boolean[] blArray = hotspot[n2];
                for (n = n3; n <= n7; ++n) {
                    objectArray[n] = d;
                    blArray[n] = true;
                }
            }
        }
        totalAbsXi = 0.0;
        for (n3 = 1; n3 <= H; ++n3) {
            double[] dArray = h[n3 - 1];
            double[] dArray2 = h[n3];
            double[] dArray3 = h[n3 + 1];
            object = hotspot[n3];
            for (n2 = 1; n2 <= W; ++n2) {
                double d = object[n2] ? 0.0 : dArray[n2] + dArray3[n2] + dArray2[n2 - 1] + dArray2[n2 + 1] - 4.0 * dArray2[n2];
                totalAbsXi += Math.abs(d);
            }
        }
        EPS_initialTotalAbsXi = 0.001 * totalAbsXi;
        MAXITER = 2 * (W + H);
        rho_s_sqr = 0.5 * (Math.cos(Math.PI / (double)W) + Math.cos(Math.PI / (double)H));
        rho_s_sqr *= rho_s_sqr;
        omega_over_4 = 0.25;
        iterations = 0;
        long l2 = System.currentTimeMillis();
        do {
            int n8;
            double[] dArray;
            double[] dArray4;
            int n9;
            totalAbsXi = 0.0;
            for (n9 = 1; n9 <= H; ++n9) {
                dArray4 = h[n9 - 1];
                object = h[n9];
                dArray = h[n9 + 1];
                objectArray = hotspot[n9];
                for (n8 = 1 + (n9 & 1); n8 <= W; n8 += 2) {
                    double d = objectArray[n8] ? 0.0 : dArray4[n8] + dArray[n8] + object[n8 - 1] + object[n8 + 1] - 4.0 * object[n8];
                    totalAbsXi += Math.abs(d);
                    int n10 = n8;
                    object[n10] = object[n10] + omega_over_4 * d;
                }
            }
            omega_over_4 = 0.25 / (1.0 - rho_s_sqr * (iterations == 0 ? 0.5 : omega_over_4));
            for (n9 = 1; n9 <= H; ++n9) {
                dArray4 = h[n9 - 1];
                object = h[n9];
                dArray = h[n9 + 1];
                objectArray = hotspot[n9];
                for (n8 = 2 - (n9 & 1); n8 <= W; n8 += 2) {
                    double d = objectArray[n8] ? 0.0 : dArray4[n8] + dArray[n8] + object[n8 - 1] + object[n8 + 1] - 4.0 * object[n8];
                    totalAbsXi += Math.abs(d);
                    int n11 = n8;
                    object[n11] = object[n11] + omega_over_4 * d;
                }
            }
            omega_over_4 = 0.25 / (1.0 - rho_s_sqr * omega_over_4);
        } while (++iterations < MAXITER && totalAbsXi >= EPS_initialTotalAbsXi);
        if (iterations == MAXITER) {
            System.err.println("HotSpotGray: Did not converge");
            System.exit(1);
        }
        long l3 = System.currentTimeMillis();
        object = new byte[H + 2][W + 2];
        GrayImageRow grayImageRow = new GrayImageRow((byte[])object[0]);
        for (int i = 0; i <= H + 1; ++i) {
            double[] dArray = h[i];
            grayImageRow.setArray((byte[])object[i]);
            for (n = 0; n <= W + 1; ++n) {
                grayImageRow.setPixel(n, (float)((dArray[n] - 0.0) / 100.0 * 1.0 + 0.0));
            }
        }
        PJGGrayImage pJGGrayImage = new PJGGrayImage(H + 2, W + 2, (byte[][])object);
        PJGImage.Writer writer = pJGGrayImage.prepareToWrite(new BufferedOutputStream(new FileOutputStream(imagefile)));
        writer.write();
        writer.close();
        long l4 = System.currentTimeMillis();
        System.out.println(iterations + " iterations");
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        System.out.println(l4 - l3 + " msec post");
        System.out.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.clu.heat.HotSpotGray <imagefile> <H> <W> <rl1> <cl1> <ru1> <cu1> <temp1> [ <rl2> <cl2> <ru2> <cu2> <temp2> . . . ]");
        System.err.println("<imagefile> = Output image file name");
        System.err.println("<H> = Mesh height in pixels (<H> >= 1)");
        System.err.println("<W> = Mesh width in pixels (<W> >= 1)");
        System.err.println("<rl1> = First hot spot lower row (1 <= <rl1> <= <W>)");
        System.err.println("<cl1> = First hot spot lower column (1 <= <cl1> <= <H>)");
        System.err.println("<ru1> = First hot spot upper row (1 <= <ru1> <= <W>)");
        System.err.println("<cu1> = First hot spot upper column (1 <= <cu1> <= <H>)");
        System.err.println("<temp1> = First hot spot temperature (0.0 <= <temp1> <= 100.0)");
        System.exit(1);
    }
}

