/*
 * Decompiled with CFR 0.152.
 */
import edu.rit.numeric.NonNegativeLeastSquares;
import java.util.List;

public class CornerDetectTopN {
    private double[][] X;
    private int K;
    private int M;
    private int L;
    private int N;
    private NonNegativeLeastSquares nnls;
    private FixSizedPriorityQueue<Convset> pq;
    private List<Convset> topconv;

    public CornerDetectTopN(double[][] X, int K, int N) {
        this.K = K;
        this.M = X.length;
        this.L = X[0].length;
        this.N = N;
        this.X = new double[this.M][this.L];
        for (int i = 0; i < this.M; ++i) {
            System.arraycopy(X[i], 0, this.X[i], 0, this.L);
        }
        this.nnls = new NonNegativeLeastSquares(this.M + 1, K);
        this.pq = new FixSizedPriorityQueue(N);
    }

    private void combine(int[] wholeset, int n) {
        if (null == wholeset || wholeset.length == 0 || n <= 0 || n > wholeset.length) {
            return;
        }
        int[] combset = new int[n];
        this.getCombination(wholeset, n, 0, combset, 0);
    }

    private void getCombination(int[] wholeset, int n, int begin, int[] combset, int index) {
        if (n == 0) {
            if (this.K != index) {
                throw new IllegalArgumentException("K != index");
            }
            double normsqrsum_tmp = 0.0;
            for (int i = 0; i < this.L; ++i) {
                int j;
                boolean innerflag = true;
                for (j = 0; j < this.K; ++j) {
                    if (i != combset[j]) continue;
                    innerflag = false;
                    break;
                }
                if (!innerflag) continue;
                for (int k = 0; k < this.K; ++k) {
                    for (int j2 = 0; j2 < this.M; ++j2) {
                        this.nnls.a[j2][k] = 1.0E-5 * this.X[j2][combset[k]];
                    }
                    this.nnls.a[this.M][k] = 1.0;
                }
                for (j = 0; j < this.M; ++j) {
                    this.nnls.b[j] = 1.0E-5 * this.X[j][i];
                }
                this.nnls.b[this.M] = 1.0;
                this.nnls.solve();
                normsqrsum_tmp += this.nnls.normsqr;
            }
            Convset conv = new Convset(normsqrsum_tmp, combset);
            this.pq.add(conv);
            return;
        }
        for (int i = begin; i < wholeset.length; ++i) {
            combset[index] = wholeset[i];
            this.getCombination(wholeset, n - 1, i + 1, combset, index + 1);
        }
    }

    public boolean search() {
        int[] wholeset = new int[this.L];
        for (int i = 0; i < this.L; ++i) {
            wholeset[i] = i;
        }
        this.combine(wholeset, this.K);
        this.topconv = this.pq.sortedList();
        return true;
    }

    public int[][] getTopNConv() {
        int[][] idx = new int[this.topconv.size()][this.K];
        int i = 0;
        for (Convset item : this.topconv) {
            System.arraycopy(item.getCornerIdx(), 0, idx[i], 0, this.K);
            ++i;
        }
        for (i = 0; i < idx.length; ++i) {
            for (int j = 0; j < idx[0].length; ++j) {
                idx[i][j] = idx[i][j] + 1;
            }
        }
        return idx;
    }

    public double[] getTopNConvErr() {
        double[] norm = new double[this.topconv.size()];
        int i = 0;
        for (Convset item : this.topconv) {
            norm[i] = item.getNorm();
            ++i;
        }
        return norm;
    }

    public static void main(String[] args) {
        double[][] X = new double[][]{{0.1, 0.2, 1.0, 0.0, 0.0, 0.5, 0.3}, {0.1, 0.7, 0.0, 1.0, 0.0, 0.5, 0.3}, {0.8, 0.1, 0.0, 0.0, 1.0, 0.0, 0.4}};
        CornerDetectTopN ex = new CornerDetectTopN(X, 3, 4);
        ex.search();
        double[] norm = ex.getTopNConvErr();
        for (int i = 0; i < norm.length; ++i) {
            System.out.print(norm[i] + ", ");
        }
        System.out.println();
        int[][] idx = ex.getTopNConv();
        for (int i = 0; i < idx.length; ++i) {
            for (int j = 0; j < idx[0].length; ++j) {
                System.out.print(idx[i][j] + ", ");
            }
            System.out.println();
        }
        System.out.println();
    }
}

