## ----echo = FALSE, message = FALSE, warning = FALSE---------------------------
library(BiocStyle)

## ----load-libs, message = FALSE,  warning = FALSE-----------------------------
library(dStruct)
library(tidyverse)

## -----------------------------------------------------------------------------
data(lai2019)

## -----------------------------------------------------------------------------
ls()

## -----------------------------------------------------------------------------
class(lai2019)

## -----------------------------------------------------------------------------
names(lai2019) %>% head()

## -----------------------------------------------------------------------------
class(lai2019[[1]])

## -----------------------------------------------------------------------------
head(lai2019[["YAL042W"]], n= 20)

## ----warning=FALSE------------------------------------------------------------
dStruct(rdf = lai2019[["YAL042W"]],
        reps_A = 3, reps_B = 2,
        batches = TRUE, min_length = 21, 
        between_combs = data.frame(c("A3", "B1", "B2")),
        within_combs = data.frame(c("A1", "A2", "A3")),
        ind_regions = TRUE)

## ----warning=FALSE------------------------------------------------------------
res <- dStructome(lai2019, 3, 2, batches= TRUE, min_length = 21,
                  between_combs = data.frame(c("A3", "B1", "B2")),
                  within_combs = data.frame(c("A1", "A2", "A3")),
                  ind_regions = TRUE, processes = 1)

## -----------------------------------------------------------------------------
head(res)

## -----------------------------------------------------------------------------
data(wan2014)

## -----------------------------------------------------------------------------
ls()

## -----------------------------------------------------------------------------
wan2014[[1]]

## -----------------------------------------------------------------------------
names(wan2014) %>% head()

## -----------------------------------------------------------------------------
dStructGuided(wan2014[[1]], 
               reps_A = 2, reps_B = 1)

## ----warning=FALSE------------------------------------------------------------
res_predefined_regs <- dStructome(wan2014, 
                                  reps_A = 2, reps_B = 1, method = "guided", 
                                  processes = 1)

## -----------------------------------------------------------------------------
head(res_predefined_regs)

## -----------------------------------------------------------------------------
toPlot <- res@elementMetadata %>%
  data.frame() %$% 
  magrittr::extract(t, order(FDR)) %>% 
  head(., n = 1)

toPlot

## ----message=FALSE, warning=FALSE---------------------------------------------
plotDStructurome(rl = lai2019[toPlot], 
                  diff_regions = subset(res, t == toPlot),
                  outfile = paste0("DRRs_in_", toPlot), 
                  fdr = 0.05, 
                  ylim = c(-0.05, 3))

## -----------------------------------------------------------------------------
sessionInfo()

