## ----eval=FALSE---------------------------------------------------------------
# if(!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# BiocManager::install("Macarron")

## -----------------------------------------------------------------------------
library(Macarron)
prism_abundances <- system.file(
    'extdata','demo_abundances.csv', package="Macarron")
prism_annotations <-system.file(
    'extdata','demo_annotations.csv', package="Macarron")
prism_metadata <-system.file(
    'extdata','demo_metadata.csv', package="Macarron")
mets_taxonomy <-system.file(
    'extdata','demo_taxonomy.csv', package="Macarron")
prism_prioritized <- Macarron::Macarron(input_abundances = prism_abundances,
                                        input_annotations = prism_annotations,
                                        input_metadata = prism_metadata,
                                        input_taxonomy = mets_taxonomy)

## ----eval=FALSE---------------------------------------------------------------
# abundances_df = read.csv(file = prism_abundances, row.names = 1) # setting features as rownames
# annotations_df = read.csv(file = prism_annotations, row.names = 1) # setting features as rownames
# metadata_df = read.csv(file = prism_metadata, row.names = 1) # setting samples as rownames
# taxonomy_df = read.csv(file = mets_taxonomy)
# 
# # Running Macarron
# prism_prioritized <- Macarron::Macarron(input_abundances = abundances_df,
#                                         input_annotations = annotations_df,
#                                         input_metadata = metadata_df,
#                                         input_taxonomy = taxonomy_df)

## ----eval = FALSE-------------------------------------------------------------
# # Step 1: Storing input data in a summarized experiment object
# prism_mbx <- prepInput(input_abundances = abundances_df,
#                        input_annotations = annotations_df,
#                        input_metadata = metadata_df)
# 
# # Step 2: Creating a distance matrix from pairwise correlations in abundances of metabolic features
# prism_w <- makeDisMat(se = prism_mbx)
# 
# # Step 3: Finding covariance modules
# prism_modules <- findMacMod(se = prism_mbx,
#                             w = prism_w,
#                             input_taxonomy = taxonomy_df)
# # The output is a list containing two dataframes- module assignments and measures of success
# # if evaluateMOS=TRUE. To write modules to a separate dataframe, do:
# prism_module_assignments <- prism_modules[[1]]
# prism_modules_mos <- prism_modules[[2]]
# 
# # Step 4: Calculating AVA
# prism_ava <- calAVA(se = prism_mbx,
#                     mod.assn = prism_modules)
# 
# # Step 5: Calculating q-value
# prism_qval <- calQval(se = prism_mbx,
#                       mod.assn = prism_modules)
# 
# # Step 6: Calculating effect size
# prism_es <- calES(se = prism_mbx,
#                    mac.qval = prism_qval)
# 
# # Step 7: Prioritizing metabolic features
# prism_prioritized <- prioritize(se = prism_mbx,
#                                 mod.assn = prism_modules,
#                                 mac.ava = prism_ava,
#                                 mac.qval = prism_qval,
#                                 mac.es = prism_es)
# # The output is a list containing two dataframes- all prioritized metabolic features and
# # only characterizable metabolic features.
# all_prioritized <- prism_prioritized[[1]]
# char_prioritized <- prism_prioritized[[2]]
# 
# # Step 8 (optional): View only the highly prioritized metabolic features in each module
# prism_highly_prioritized <- showBest(prism_prioritized)

## -----------------------------------------------------------------------------
sessionInfo()

## ----eval=FALSE---------------------------------------------------------------
# taxonomy_df <- decorateID(input_annotations = annotations_df)
# write.csv(taxonomy_df, file="demo_taxonomy.csv", row.names = FALSE)

## ----eval=FALSE---------------------------------------------------------------
# prism_prioritized <- Macarron::Macarron(input_abundances = abundances_df,
#                                         input_annotations = annotations_df,
#                                         input_metadata = metadata_df,
#                                         input_taxonomy = taxonomy_df,
#                                         min_prevalence = 0.5)
# # or
# prism_w <- makeDisMat(se = prism_mbx,
#                       min_prevalence = 0.5)

## ----eval=FALSE---------------------------------------------------------------
# # See MOS of modules generated using default
# prism_modules <- findMacMod(se = prism_mbx,
#                             w = prism_w,
#                             input_taxonomy = taxonomy_df)
# prism_modules_mos <- prism_modules[[2]]
# View(prism_modules_mos)
# 
# # Change MMS
# prism_modules <- findMacMod(se = prism_mbx,
#                             w = prism_w,
#                             input_taxonomy = taxonomy_df,
#                             min_module_size = 10)

## ----eval=FALSE---------------------------------------------------------------
# prism_qval <- calQval(se = prism_mbx,
#                       mod.assn = prism_modules,
#                       metadata_variable = "diagnosis",
#                       fixed_effects = c("diagnosis","age","antibiotics"),
#                       reference = c("diagnosis,Control";"antibiotics,No"))

